/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.converters.wiki;

import com.atlassian.mail.MailUtils;
import com.atlassian.mail.converters.HtmlConverter;
import com.atlassian.mail.converters.wiki.BlockStyleHandler;
import com.atlassian.mail.converters.wiki.DocumentUtilities;
import com.atlassian.mail.converters.wiki.FontStyleHandler;
import com.atlassian.mail.converters.wiki.LinkAndImageHandler;
import com.atlassian.mail.converters.wiki.ListHandler;
import com.atlassian.mail.converters.wiki.TableHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlToWikiTextConverter
implements HtmlConverter {
    private static final char WIKI_LINK_START_CHAR = '[';
    private static final char WIKI_TABLE_CHAR = '|';
    private static final char NEWLINE_CHAR = '\n';
    private static final String NEWLINE = Character.toString('\n');
    private static final String WIKI_TABLE = Character.toString('|');
    private static final String NON_WIKI_TEXT_REPLACE = ":";
    private static final String WIKI_LINK_START = Character.toString('[');
    private static final String WIKI_LINK_END = "]";
    private final List<MailUtils.Attachment> attachments;

    public HtmlToWikiTextConverter(@Nonnull List<MailUtils.Attachment> attachments) {
        this.attachments = ImmutableList.copyOf(attachments);
    }

    @Override
    public String convert(@Nonnull String html) throws IOException {
        DocumentUtilities.DocumentElement document = DocumentUtilities.parseHtml(html);
        DocumentUtilities.BodyElement body = DocumentUtilities.getBody(document);
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor traversor = new NodeTraversor((NodeVisitor)formatter);
        traversor.traverse((Node)body.getBody());
        return formatter.toString();
    }

    static /* synthetic */ List access$100(HtmlToWikiTextConverter x0) {
        return x0.attachments;
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private final StringBuilder accum = new StringBuilder();
        private final BlockStyleHandler blockStyleHandler = new BlockStyleHandler();
        private final FontStyleHandler fontStyleHandler = new FontStyleHandler(this.blockStyleHandler);
        private final ListHandler listHandler = new ListHandler(this.blockStyleHandler);
        private final TableHandler tableHandler = new TableHandler(this.blockStyleHandler);
        private final LinkAndImageHandler linkAndImageHandler = new LinkAndImageHandler(this.blockStyleHandler, HtmlToWikiTextConverter.access$100(HtmlToWikiTextConverter.this));

        private FormattingVisitor() {
        }

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                String text = ((TextNode)node).text();
                if (this.fontStyleHandler.isAnyAtStart(depth)) {
                    text = StringUtils.stripStart((String)text, null);
                }
                if (this.tableHandler.isInTable()) {
                    text = StringUtils.replace((String)text, (String)WIKI_TABLE, (String)HtmlToWikiTextConverter.NON_WIKI_TEXT_REPLACE);
                }
                if (this.linkAndImageHandler.isInsideLinkWithText()) {
                    text = StringUtils.replace((String)text, (String)WIKI_LINK_START, (String)HtmlToWikiTextConverter.NON_WIKI_TEXT_REPLACE);
                    text = StringUtils.replace((String)text, (String)HtmlToWikiTextConverter.WIKI_LINK_END, (String)HtmlToWikiTextConverter.NON_WIKI_TEXT_REPLACE);
                }
                if (this.tableHandler.isInTable()) {
                    this.append(node, text, WhitespaceNewlineHandling.ONE);
                } else if (this.linkAndImageHandler.isInsideLinkWithText()) {
                    this.append(node, text, WhitespaceNewlineHandling.NONE);
                } else {
                    this.append(node, text);
                }
            } else if (StringUtil.in((String)name, (String[])new String[]{"b", "strong", "i", "em", "u", "ins", "strike", "del", "s", "q", "cite"})) {
                Element element;
                String enterText = this.fontStyleHandler.enter(node, name, depth);
                if (StringUtils.isNotEmpty((String)enterText) && node instanceof Element && (element = (Element)node).hasText()) {
                    String removedWhitespace = "";
                    Node firstChildNode = element.childNodeSize() > 0 ? element.childNode(0) : null;
                    String text = firstChildNode instanceof TextNode ? ((TextNode)firstChildNode).getWholeText() : element.text();
                    while (text.length() > 0 && StringUtil.isWhitespace((int)text.charAt(0))) {
                        removedWhitespace = removedWhitespace + text.charAt(0);
                        text = StringUtils.substring((String)text, (int)1);
                    }
                    if (!this.fontStyleHandler.isPrecededByStyle(this.accum.toString())) {
                        this.append(node, removedWhitespace);
                    }
                }
                this.append(node, enterText);
            } else if (StringUtil.in((String)name, (String[])new String[]{"blockquote", "pre", "code"})) {
                this.append(node, this.blockStyleHandler.enter(node, name, depth));
            } else if (StringUtil.in((String)name, (String[])new String[]{"h1", "h2", "h3", "h4", "h5", "h6"})) {
                this.append(node, NEWLINE + name + ". ");
            } else if (StringUtil.in((String)name, (String[])new String[]{"ol", "ul", "li", "dl", "dd", "dt"})) {
                this.append(node, this.listHandler.enter(name), WhitespaceNewlineHandling.ONE);
            } else if (StringUtil.in((String)name, (String[])new String[]{"table", "tr", "th", "td"})) {
                WhitespaceNewlineHandling whitespaceNewlineHandling = WhitespaceNewlineHandling.NONE;
                if (StringUtil.in((String)name, (String[])new String[]{"table", "tr"}) || this.tableHandler.isFirstTableRowData()) {
                    whitespaceNewlineHandling = WhitespaceNewlineHandling.ONE;
                }
                this.append(node, this.tableHandler.enter(name), whitespaceNewlineHandling);
            } else if (StringUtil.in((String)name, (String[])new String[]{"a", "img"})) {
                this.append(node, this.linkAndImageHandler.enter(node, name));
            } else if (StringUtil.in((String)name, (String[])new String[]{"p", "div"})) {
                if (name.equals("div")) {
                    if (node.childNodeSize() > 0) {
                        boolean treatNewline;
                        Node child = node.childNode(0);
                        if (child instanceof TextNode) {
                            String text = ((TextNode)child).text();
                            treatNewline = StringUtils.isNotBlank((String)text);
                        } else {
                            treatNewline = child instanceof Element ? !StringUtil.in((String)((Element)child).tagName(), (String[])new String[]{"br", "p"}) : true;
                        }
                        if (treatNewline && !this.fontStyleHandler.isInsideStyling()) {
                            this.append(node, NEWLINE);
                        }
                    }
                } else if (!this.fontStyleHandler.isInsideStyling()) {
                    this.append(node, NEWLINE + NEWLINE);
                }
            }
        }

        public void tail(Node node, int depth) {
            String name = node.nodeName();
            if (name.equals("br")) {
                if (!this.fontStyleHandler.isInsideStyling()) {
                    this.append(node, NEWLINE);
                }
            } else if (name.equals("hr")) {
                this.append(node, NEWLINE + "----" + NEWLINE, WhitespaceNewlineHandling.ONE);
            } else if (StringUtil.in((String)name, (String[])new String[]{"b", "strong", "i", "em", "u", "ins", "strike", "del", "s", "q", "cite"})) {
                String text;
                Element element;
                Node sibling;
                String fontExit = this.fontStyleHandler.exit(name, depth);
                String removedWhitespace = "";
                if (StringUtils.isNotBlank((String)fontExit) && this.accum.length() > 0) {
                    while (StringUtil.isWhitespace((int)this.accum.charAt(this.accum.length() - 1))) {
                        removedWhitespace = removedWhitespace + this.accum.substring(this.accum.length() - 1);
                        this.accum.deleteCharAt(this.accum.length() - 1);
                    }
                }
                this.append(node, fontExit);
                if (!this.fontStyleHandler.isInsideStyling() && node instanceof Element && (sibling = (element = (Element)node).nextSibling()) != null && sibling instanceof TextNode && StringUtils.isNotEmpty((String)(text = ((TextNode)sibling).text())) && !StringUtil.isWhitespace((int)text.charAt(0)) && !Pattern.matches("\\p{Punct}", StringUtils.substring((String)text, (int)0, (int)1))) {
                    this.append(node, " ");
                }
                this.append(node, removedWhitespace);
            } else if (StringUtil.in((String)name, (String[])new String[]{"blockquote", "pre", "code"})) {
                this.append(node, this.blockStyleHandler.exit(name, depth));
            } else if (StringUtil.in((String)name, (String[])new String[]{"h1", "h2", "h3", "h4", "h5", "h6"})) {
                this.append(node, NEWLINE);
            } else if (StringUtil.in((String)name, (String[])new String[]{"ol", "ul", "li", "dl", "dd", "dt"})) {
                this.append(node, this.listHandler.exit(name), WhitespaceNewlineHandling.ONE);
            } else if (StringUtil.in((String)name, (String[])new String[]{"table", "tr", "th", "td"})) {
                this.append(node, this.tableHandler.exit(name), WhitespaceNewlineHandling.NONE);
                if (StringUtil.in((String)name, (String[])new String[]{"table", "tr"})) {
                    this.append(node, NEWLINE, WhitespaceNewlineHandling.ONE);
                }
            } else if ("a".equals(name)) {
                this.append(node, this.linkAndImageHandler.exit(node, name));
            }
        }

        private void append(Node node, String text) {
            this.append(node, text, WhitespaceNewlineHandling.UNCHANGED);
        }

        private void append(Node node, String text, WhitespaceNewlineHandling whitespaceNewlineHandling) {
            text = StringUtils.replace((String)text, (String)("\r" + NEWLINE), (String)NEWLINE);
            text = StringUtils.replace((String)text, (String)"\f", (String)NEWLINE);
            text = StringUtils.replace((String)text, (String)"\r", (String)NEWLINE);
            text = StringUtils.replace((String)text, (String)"\t", (String)" ");
            if (this.accum.length() == 0) {
                text = StringUtils.stripStart((String)text, null);
            } else if (whitespaceNewlineHandling == WhitespaceNewlineHandling.NONE || whitespaceNewlineHandling == WhitespaceNewlineHandling.ONE) {
                String removed = "";
                while (StringUtil.isWhitespace((int)this.accum.charAt(this.accum.length() - 1))) {
                    removed = removed + this.accum.charAt(this.accum.length() - 1);
                    this.accum.deleteCharAt(this.accum.length() - 1);
                }
                while (StringUtils.isNotEmpty((String)text) && StringUtil.isWhitespace((int)text.charAt(0))) {
                    removed = removed + text.charAt(0);
                    text = StringUtils.substring((String)text, (int)1);
                }
                if (StringUtils.containsAny((String)removed, (String)" ")) {
                    if (this.linkAndImageHandler.isInsideLinkWithText()) {
                        if (this.accum.charAt(this.accum.length() - 1) != '[') {
                            this.accum.append(' ');
                        }
                    } else {
                        this.accum.append(' ');
                    }
                }
                if (whitespaceNewlineHandling == WhitespaceNewlineHandling.ONE && StringUtils.contains((String)removed, (char)'\n') && !this.tableHandler.isStartOfTableData(node) && (!this.tableHandler.isInTable() || this.tableHandler.isEndOfRow() || this.tableHandler.isFirstTableRowData())) {
                    this.accum.append(NEWLINE);
                }
            }
            if (StringUtils.startsWith((String)text, (String)NEWLINE)) {
                char last = this.accum.charAt(this.accum.length() - 1);
                if (this.tableHandler.isStartOfTableData(node) && (StringUtil.isWhitespace((int)last) || last == '|')) {
                    text = StringUtils.strip((String)text, (String)NEWLINE);
                }
            }
            this.accum.append(text);
        }

        public String toString() {
            return this.accum.toString();
        }
    }

    private static enum WhitespaceNewlineHandling {
        NONE,
        ONE,
        UNCHANGED;

    }
}

