/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail;

import com.atlassian.core.util.ImageInfo;
import com.atlassian.mail.HtmlConverter;
import com.atlassian.mail.converters.basic.HtmlToTextConverter;
import com.atlassian.net.NetworkUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class MailUtils {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    static final int BUFFER_SIZE = 65536;
    static final String MULTIPART_ALTERNATE_CONTENT_TYPE = "multipart/alternative";
    static final String MULTIPART_RELATED_CONTENT_TYPE = "multipart/related";
    static final String TEXT_CONTENT_TYPE = "text/plain";
    static final String MESSAGE_CONTENT_TYPE = "message/rfc822";
    static final String HTML_CONTENT_TYPE = "text/html";
    static final String CONTENT_TYPE_X_PKCS7 = "application/x-pkcs7-signature";
    static final String CONTENT_TYPE_PKCS7 = "application/pkcs7-signature";
    private static final com.atlassian.mail.converters.HtmlConverter htmlConverter = new HtmlToTextConverter();
    private static final Logger log = Logger.getLogger(MailUtils.class);
    private static final String CONTENT_TRANSFER_ENCODING_HEADER = "Content-Transfer-Encoding";
    private static final String MAIL_HEADER_SUBJECT = "Subject";
    private static final String EML_FILE_EXTENSION = "eml";
    private static final String MAIL_CONTENT_TYPE_IMAGE_FIRST_PART = "image/";
    private static final String MAIL_SUBJECT_TO_ATTACHMENT_FILENAME_SANITIZING_REGEX = "[\\.\\-\\*#\\|\\{\\}:=%\\?\\+\\^\\~!\\\\\\/@\\[\\]\\'\"`\\$\\(\\);& ]";
    private static final String MAIL_SUBJECT_TO_ATTACHMENT_FILENAME_SANITIZING_REPLACER_CHARACTER = "_";
    private static final String CONTENT_ID_HEADER = "Content-ID";
    private static final String CONTENT_ID_WRAPPER = "<>";

    public static InternetAddress[] parseAddresses(String addresses) throws AddressException {
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        list.clear();
        StringTokenizer st = new StringTokenizer(addresses, ", ");
        while (st.hasMoreTokens()) {
            list.add(new InternetAddress(st.nextToken()));
        }
        return list.toArray(new InternetAddress[list.size()]);
    }

    public static String getBody(Message message) throws MessagingException {
        return MailUtils.getBody(message, htmlConverter);
    }

    @Deprecated
    public static String getBody(Message message, HtmlConverter htmlConverter) throws MessagingException {
        return MailUtils.getBody(message, htmlConverter, false);
    }

    public static String getBody(Message message, com.atlassian.mail.converters.HtmlConverter htmlConverter) throws MessagingException {
        return MailUtils.getBody(message, htmlConverter, false);
    }

    @Deprecated
    public static String getBody(Message message, final HtmlConverter htmlConverter, boolean preferHtmlBody) throws MessagingException {
        com.atlassian.mail.converters.HtmlConverter updatedHtmlConverter = new com.atlassian.mail.converters.HtmlConverter(){

            @Override
            public String convert(@Nonnull String html) throws IOException {
                return htmlConverter.convert(html);
            }
        };
        return MailUtils.getBody(message, updatedHtmlConverter, preferHtmlBody);
    }

    public static String getBody(Message message, com.atlassian.mail.converters.HtmlConverter htmlConverter, boolean preferHtmlBody) throws MessagingException {
        return StringUtils.strip((String)MailUtils.internalGetBody(message, htmlConverter, preferHtmlBody));
    }

    private static String internalGetBody(Message message, com.atlassian.mail.converters.HtmlConverter htmlConverter, boolean preferHtmlBody) throws MessagingException {
        try {
            String content = MailUtils.extractTextFromPart((Part)message, htmlConverter);
            if (content == null && message.getContent() instanceof Multipart) {
                content = MailUtils.getBodyFromMultipart((Multipart)message.getContent(), htmlConverter, preferHtmlBody);
            }
            if (content == null) {
                log.info((Object)"Could not find any body to extract from the message");
            }
            return content;
        }
        catch (ClassCastException cce) {
            log.info((Object)("Exception getting the content type of message - probably not of type 'String': " + cce.getMessage()));
            return null;
        }
        catch (IOException e) {
            log.info((Object)("IOException whilst getting message content " + e.getMessage()));
            return null;
        }
    }

    public static Attachment[] getAttachments(Message message) throws MessagingException, IOException {
        List<Attachment> attachments = MailUtils.internalGetAttachments(message);
        return attachments.toArray(new Attachment[attachments.size()]);
    }

    private static List<Attachment> internalGetAttachments(Message message) throws MessagingException, IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (message.getContent() instanceof Multipart) {
            MailUtils.addAttachments(attachments, (Multipart)message.getContent());
        }
        return attachments;
    }

    private static void addAttachments(List<Attachment> attachments, Multipart parts) throws MessagingException, IOException {
        int n = parts.getCount();
        for (int i = 0; i < n; ++i) {
            Object content;
            BodyPart part = parts.getBodyPart(i);
            if (MailUtils.isAttachment(part)) {
                content = part.getInputStream();
                String contentType = part.getContentType();
                String contentId = MailUtils.getContentId((Part)part);
                byte[] contents = IOUtils.toByteArray((InputStream)content);
                String fileName = MimeUtility.decodeText((String)MailUtils.getAttachmentFilename(part, contents));
                attachments.add(new Attachment(contentId, contentType, fileName, contents));
                continue;
            }
            try {
                content = part.getContent();
                if (content instanceof Message) {
                    attachments.addAll(MailUtils.internalGetAttachments((Message)content));
                    continue;
                }
                if (!(content instanceof Multipart)) continue;
                MailUtils.addAttachments(attachments, (Multipart)content);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)"Unsupported encoding found for part while trying to discover attachments. Attachment will be ignored.", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    static String getAttachmentFilename(BodyPart attachment, byte[] contents) throws MessagingException, IOException {
        String fileName = attachment.getFileName();
        String fileExtension = "";
        if (fileName == null) {
            fileName = RandomStringUtils.randomAlphanumeric((int)8);
            if (MailUtils.isPartMessageType((Part)attachment)) {
                String[] subjects;
                Part innerMessage = (Part)attachment.getContent();
                String[] stringArray = subjects = innerMessage != null ? innerMessage.getHeader(MAIL_HEADER_SUBJECT) : new String[]{};
                if (subjects != null && subjects.length > 0) {
                    fileExtension = EML_FILE_EXTENSION;
                    fileName = MailUtils.sanitizeFilenameFromMailSubject(subjects[0]);
                }
            } else {
                ImageInfo imageInfo = new ImageInfo();
                imageInfo.setInput((InputStream)new ByteArrayInputStream(contents));
                imageInfo.check();
                String formatName = imageInfo.getFormatName();
                if (StringUtils.isNotBlank((String)formatName) && !formatName.trim().equals("?")) {
                    fileExtension = formatName.toLowerCase();
                } else if (MailUtils.getContentType((Part)attachment).startsWith(MAIL_CONTENT_TYPE_IMAGE_FIRST_PART)) {
                    fileExtension = MailUtils.getContentType((Part)attachment).substring(MAIL_CONTENT_TYPE_IMAGE_FIRST_PART.length());
                }
            }
        }
        return StringUtils.isNotEmpty((String)fileExtension) ? String.format("%s.%s", fileName, fileExtension) : fileName;
    }

    @VisibleForTesting
    static String sanitizeFilenameFromMailSubject(String subject) {
        return subject.replaceAll(MAIL_SUBJECT_TO_ATTACHMENT_FILENAME_SANITIZING_REGEX, MAIL_SUBJECT_TO_ATTACHMENT_FILENAME_SANITIZING_REPLACER_CHARACTER);
    }

    public static boolean isAttachment(BodyPart part) throws MessagingException {
        return "attachment".equalsIgnoreCase(part.getDisposition()) || part.getDisposition() == null && StringUtils.isNotBlank((String)part.getFileName()) || MailUtils.isPartInline((Part)part);
    }

    public static boolean hasRecipient(String matchEmail, Message message) throws MessagingException {
        Address[] addresses = message.getAllRecipients();
        if (addresses == null || addresses.length == 0) {
            return false;
        }
        for (int i = 0; i < addresses.length; ++i) {
            InternetAddress email = (InternetAddress)addresses[i];
            if (matchEmail.compareToIgnoreCase(email.getAddress()) != 0) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSenders(Message message) throws MessagingException {
        ArrayList<String> senders = new ArrayList<String>();
        Address[] addresses = message.getFrom();
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                InternetAddress addr;
                String emailAddress;
                if (!(addresses[i] instanceof InternetAddress) || (emailAddress = StringUtils.trimToNull((String)(addr = (InternetAddress)addresses[i]).getAddress())) == null) continue;
                senders.add(emailAddress);
            }
        }
        return senders;
    }

    public static MimeBodyPart createAttachmentMimeBodyPart(String path) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(path);
        attachmentPart.setDataHandler(new DataHandler((DataSource)source));
        String fileName = MailUtils.extractFilenameFromPath(path);
        attachmentPart.setFileName(fileName);
        return attachmentPart;
    }

    private static String extractFilenameFromPath(String path) {
        String fileName;
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, "\\/");
        do {
            fileName = st.nextToken();
        } while (st.hasMoreTokens());
        return fileName;
    }

    public static MimeBodyPart createZippedAttachmentMimeBodyPart(String path) throws MessagingException {
        File tmpFile = null;
        String fileName = MailUtils.extractFilenameFromPath(path);
        try {
            tmpFile = File.createTempFile("atlassian", null);
            FileOutputStream fout = new FileOutputStream(tmpFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            zout.putNextEntry(new ZipEntry(fileName));
            FileInputStream in = new FileInputStream(path);
            byte[] buffer = new byte[65536];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buffer))) {
                zout.write(buffer, 0, n);
            }
            zout.close();
            ((InputStream)in).close();
            log.debug((Object)("Wrote temporary zip of attachment to " + tmpFile));
        }
        catch (FileNotFoundException e) {
            String err = "Couldn't find file '" + path + "' on server: " + e;
            log.error((Object)err, (Throwable)e);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(err);
            return mimeBodyPart;
        }
        catch (IOException e) {
            String err = "Error zipping log file '" + path + "' on server: " + e;
            log.error((Object)err, (Throwable)e);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(err);
            return mimeBodyPart;
        }
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(tmpFile);
        attachmentPart.setDataHandler(new DataHandler((DataSource)source));
        attachmentPart.setFileName(fileName + ".zip");
        attachmentPart.setHeader("Content-Type", "application/zip");
        return attachmentPart;
    }

    private static String getBodyFromMultipart(Multipart multipart, com.atlassian.mail.converters.HtmlConverter htmlConverter, boolean preferHtmlBody) throws MessagingException, IOException {
        StringBuffer sb = new StringBuffer();
        MailUtils.getBodyFromMultipart(multipart, sb, htmlConverter, preferHtmlBody);
        return sb.toString();
    }

    private static void getBodyFromMultipart(Multipart multipart, StringBuffer sb, com.atlassian.mail.converters.HtmlConverter htmlConverter, boolean preferHtmlBody) throws MessagingException, IOException {
        String multipartType = multipart.getContentType();
        if (multipartType != null && MailUtils.compareContentType(multipartType, MULTIPART_ALTERNATE_CONTENT_TYPE)) {
            LinkedList<String> contentTypeToTry = new LinkedList<String>();
            if (preferHtmlBody) {
                contentTypeToTry.add(HTML_CONTENT_TYPE);
                contentTypeToTry.add(TEXT_CONTENT_TYPE);
            } else {
                contentTypeToTry.add(TEXT_CONTENT_TYPE);
                contentTypeToTry.add(HTML_CONTENT_TYPE);
            }
            BodyPart part = MailUtils.getFirstInlinePartWithMimeType(multipart, (String)contentTypeToTry.poll());
            if (part == null) {
                part = MailUtils.getFirstInlinePartWithMimeType(multipart, (String)contentTypeToTry.poll());
            }
            MailUtils.appendMultipartText(MailUtils.extractTextFromPart((Part)part, htmlConverter), sb);
            return;
        }
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = part.getContentType();
            if ("attachment".equalsIgnoreCase(part.getDisposition()) || contentType == null) continue;
            try {
                String content = MailUtils.extractTextFromPart((Part)part, htmlConverter);
                if (content != null) {
                    MailUtils.appendMultipartText(content, sb);
                    continue;
                }
                Object contentPart = part.getContent();
                if (contentPart instanceof Message) {
                    String bodyMessagePart = MailUtils.internalGetBody((Message)contentPart, htmlConverter, preferHtmlBody);
                    MailUtils.appendMultipartText(bodyMessagePart, sb);
                    continue;
                }
                if (!(contentPart instanceof Multipart)) continue;
                MailUtils.getBodyFromMultipart((Multipart)contentPart, sb, htmlConverter, preferHtmlBody);
                continue;
            }
            catch (IOException exception) {
                log.warn((Object)("Error retrieving content from part '" + exception.getMessage() + "'"), (Throwable)exception);
            }
        }
    }

    private static void appendMultipartText(String content, StringBuffer sb) throws IOException, MessagingException {
        if (content != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(content);
        }
    }

    private static String extractTextFromPart(Part part, com.atlassian.mail.converters.HtmlConverter htmlConverter) throws MessagingException, IOException {
        if (part == null) {
            return null;
        }
        String content = null;
        if (MailUtils.isPartPlainText(part)) {
            try {
                content = (String)part.getContent();
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)("Found unsupported encoding '" + e.getMessage() + "'. Reading content with " + DEFAULT_ENCODING + " encoding."));
                content = MailUtils.getBody(part, DEFAULT_ENCODING);
            }
        } else if (MailUtils.isPartHtml(part)) {
            content = htmlConverter.convert((String)part.getContent());
        }
        if (content == null) {
            log.debug((Object)("Unable to extract text from MIME part with Content-Type '" + part.getContentType() + "'"));
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBody(Part part, String charsetName) throws IOException, MessagingException {
        String string;
        BufferedReader input = null;
        StringWriter output = null;
        try {
            input = new BufferedReader(new InputStreamReader(part.getInputStream(), charsetName));
            output = new StringWriter();
            IOUtils.copy((Reader)input, (Writer)output);
            string = output.getBuffer().toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)input);
        IOUtils.closeQuietly((Writer)output);
        return string;
    }

    private static BodyPart getFirstInlinePartWithMimeType(Multipart multipart, String mimeType) throws MessagingException, IOException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = part.getContentType();
            if ("attachment".equals(part.getDisposition()) || contentType == null) continue;
            if (MailUtils.compareContentType(contentType, mimeType)) {
                return part;
            }
            if (!MailUtils.isPartRelated((Part)part) || !(part.getContent() instanceof Multipart)) continue;
            return MailUtils.getFirstInlinePartWithMimeType((Multipart)part.getContent(), mimeType);
        }
        return null;
    }

    private static boolean compareContentType(String contentType, String mimeType) {
        return contentType.toLowerCase().startsWith(mimeType);
    }

    public static boolean isPartHtml(Part part) throws MessagingException {
        String contentType = MailUtils.getContentType(part);
        return HTML_CONTENT_TYPE.equalsIgnoreCase(contentType);
    }

    public static boolean isPartPlainText(Part part) throws MessagingException {
        String contentType = MailUtils.getContentType(part);
        return TEXT_CONTENT_TYPE.equalsIgnoreCase(contentType);
    }

    public static boolean isPartMessageType(Part part) throws MessagingException {
        String contentType = MailUtils.getContentType(part);
        return MESSAGE_CONTENT_TYPE.equalsIgnoreCase(contentType);
    }

    public static boolean isPartRelated(Part part) throws MessagingException {
        String contentType = MailUtils.getContentType(part);
        return MULTIPART_RELATED_CONTENT_TYPE.equalsIgnoreCase(contentType);
    }

    public static String getContentType(Part part) throws MessagingException {
        MailUtils.checkPartNotNull(part);
        String contentType = part.getContentType();
        return MailUtils.getContentType(contentType);
    }

    public static String getContentType(String headerValue) {
        MailUtils.checkHeaderValue(headerValue);
        String out = headerValue;
        int semiColon = headerValue.indexOf(59);
        if (-1 != semiColon) {
            out = headerValue.substring(0, semiColon);
        }
        return out.trim();
    }

    private static void checkHeaderValue(String headerValue) {
        Validate.notEmpty((String)headerValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContentEmpty(Part part) throws MessagingException, IOException {
        MailUtils.checkPartNotNull(part);
        boolean definitelyEmpty = false;
        Object content = part.getContent();
        if (null == content) {
            definitelyEmpty = true;
        } else {
            if (content instanceof String) {
                String stringContent = (String)content;
                definitelyEmpty = StringUtils.isBlank((String)stringContent);
            }
            if (content instanceof InputStream) {
                InputStream inputStream = (InputStream)content;
                try {
                    int firstByte = inputStream.read();
                    definitelyEmpty = -1 == firstByte;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        return definitelyEmpty;
    }

    private static void checkPartNotNull(Part part) {
        Validate.notNull((Object)part, (String)"part should not be null.");
    }

    public static boolean isPartInline(Part part) throws MessagingException {
        MailUtils.checkPartNotNull(part);
        boolean inline = false;
        String disposition = part.getDisposition();
        if ("inline".equalsIgnoreCase(disposition)) {
            String file = part.getFileName();
            if (StringUtils.isNotBlank((String)file)) {
                inline = true;
            }
            return inline;
        }
        boolean gotContentId = MailUtils.hasContentId(part);
        if (!gotContentId) {
            return false;
        }
        boolean gotBase64 = MailUtils.isContentBase64Encoded(part);
        return gotBase64;
    }

    public static String getContentId(Part part) throws MessagingException {
        String[] contentIds = part.getHeader(CONTENT_ID_HEADER);
        if (contentIds != null) {
            for (String contentId : contentIds) {
                if (!StringUtils.isNotEmpty((String)contentId)) continue;
                return StringUtils.strip((String)contentId, (String)CONTENT_ID_WRAPPER);
            }
        }
        return "";
    }

    private static boolean hasContentId(Part part) throws MessagingException {
        return StringUtils.isNotEmpty((String)MailUtils.getContentId(part));
    }

    private static boolean isContentBase64Encoded(Part part) throws MessagingException {
        boolean gotBase64 = false;
        String[] contentTransferEncodings = part.getHeader(CONTENT_TRANSFER_ENCODING_HEADER);
        if (null != contentTransferEncodings) {
            for (int i = 0; i < contentTransferEncodings.length; ++i) {
                String contentTransferEncoding = contentTransferEncodings[i];
                if (!"base64".equals(contentTransferEncoding)) continue;
                gotBase64 = true;
                break;
            }
        }
        return gotBase64;
    }

    public static boolean isPartAttachment(Part part) throws MessagingException {
        MailUtils.checkPartNotNull(part);
        return "attachment".equalsIgnoreCase(part.getDisposition());
    }

    public static String fixMimeEncodedFilename(String filename) throws IOException {
        String newFilename = filename;
        if (filename.startsWith("=?") || filename.endsWith("?=")) {
            newFilename = MimeUtility.decodeText((String)filename);
        }
        return newFilename;
    }

    public static boolean isPartSignaturePKCS7(Part part) throws MessagingException {
        MailUtils.checkPartNotNull(part);
        String contentType = MailUtils.getContentType(part).toLowerCase(Locale.getDefault());
        return contentType.startsWith(CONTENT_TYPE_PKCS7) || contentType.startsWith(CONTENT_TYPE_X_PKCS7);
    }

    public static String getLocalHostName() {
        String hostname = null;
        try {
            hostname = NetworkUtils.getLocalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
        if (hostname == null || hostname.length() == 0) {
            return "localhost";
        }
        if (MailUtils.isIpAddress(hostname)) {
            return '[' + hostname + ']';
        }
        return hostname;
    }

    public static boolean isIpAddress(String hostname) {
        boolean containsAlpha = false;
        boolean containsDot = false;
        for (int i = 0; i < hostname.length(); ++i) {
            char ch = hostname.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            if (ch == '.') {
                containsDot = true;
                continue;
            }
            if (ch == ':') {
                return true;
            }
            if (ch >= 'a' && ch <= 'f') {
                containsAlpha = true;
                continue;
            }
            if (ch >= 'A' && ch <= 'F') {
                containsAlpha = true;
                continue;
            }
            return false;
        }
        return containsDot && !containsAlpha;
    }

    public static class Attachment {
        private final String contentId;
        private final String contentType;
        private final String fileName;
        private final byte[] contents;

        public Attachment(String contentId, String contentType, String fileName, byte[] contents) {
            this.contentId = contentId;
            this.contentType = contentType;
            this.fileName = fileName;
            this.contents = contents;
        }

        public Attachment(String contentType, String fileName, byte[] contents) {
            this(null, contentType, fileName, contents);
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getContents() {
            return this.contents;
        }

        public String getFilename() {
            return this.fileName;
        }

        public String getContentId() {
            return this.contentId;
        }
    }
}

