package com.atlassian.mail.converters.wiki;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
final class DocumentUtilities {

    private DocumentUtilities() {
    }

    static DocumentElement parseHtml(final String html) {
        final Document document = Jsoup.parse(html);

        document.outputSettings().prettyPrint(false);

        return new DocumentElement(document);
    }

    static BodyElement getBody(final DocumentElement document) {
        final Element body = document.getDocument().body();
        return new BodyElement(body);
    }

    static class DocumentElement {
        private final Document document;

        private DocumentElement(Document document) {
            this.document = checkNotNull(document, "Document can not be null");
        }

        public Document getDocument() {
            return document;
        }
    }

    static class BodyElement {
        private final Element body;

        private BodyElement(Element body) {
            this.body = checkNotNull(body, "Body can not be null");
            checkArgument(body.tag().getName().equals("body"), "Element must be the body");
        }

        public Element getBody() {
            return body;
        }
    }

}
