/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail;

import com.atlassian.mail.HtmlConverter;
import com.atlassian.mail.HtmlToTextConverter;
import com.atlassian.mail.MailUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class HtmlToWikiTextConverter
implements HtmlConverter {
    private static final String HTML_IMG = "img";
    private static final String HTML_ATL = "alt";
    private static final String HTML_SRC = "src";
    private static final String WIKI_MACRO_ATTACHMENT = "!%s|thumbnail!";
    private static final String CONTENT_ID_PREFIX = "cid:";
    private static final Category log = Category.getInstance(HtmlToTextConverter.class);
    private final HtmlToTextConverter htmlToPlainTextConverter = new HtmlToTextConverter();
    private final List<MailUtils.Attachment> attachments;

    public HtmlToWikiTextConverter(List<MailUtils.Attachment> attachments) {
        this.attachments = attachments;
    }

    @Override
    public String convert(String html) throws IOException {
        Document document = Jsoup.parse((String)html);
        Elements imageElements = document.body().getElementsByTag(HTML_IMG);
        for (Element imageElement : imageElements) {
            imageElement.replaceWith((Node)this.wikiMacroForImage(imageElement));
        }
        return this.htmlToPlainTextConverter.convert(document.outerHtml());
    }

    private TextNode wikiMacroForImage(Element imageElement) {
        String imageSource = imageElement.attr(HTML_SRC);
        String contentId = StringUtils.removeStart((String)imageSource, (String)CONTENT_ID_PREFIX);
        MailUtils.Attachment image = this.getAttachmentById(contentId);
        if (image != null) {
            return this.textNode(String.format(WIKI_MACRO_ATTACHMENT, image.getFilename()));
        }
        String alternativeText = imageElement.attr(HTML_ATL);
        log.warn((Object)("Could not find attachment: " + alternativeText + " for content id: " + contentId));
        return this.textNode(alternativeText);
    }

    private TextNode textNode(String text) {
        return new TextNode(text, "");
    }

    private MailUtils.Attachment getAttachmentById(String contentId) {
        for (MailUtils.Attachment attachment : this.attachments) {
            if (!StringUtils.equalsIgnoreCase((String)attachment.getContentId(), (String)contentId)) continue;
            return attachment;
        }
        return null;
    }
}

