package com.atlassian.mail.server.impl;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

/**
 * Extends the standard JavaMail MimeMessage in order to allow clients to set a custom Message-ID
 *
 * @since v2.5.0
 */
public class ExtendedMimeMessage extends MimeMessage
{
    private final String customMessageId;

    /**
     * Constructs an ExtendedMimeMessage.
     *
     * @param session the mail session
     * @param customMessageId requested custom Message-ID or null to let JavaMail set one automatically.
     */
    public ExtendedMimeMessage(final Session session, final String customMessageId)
    {
        super(session);
        this.customMessageId = customMessageId;
    }

    @Override
    protected void updateMessageID() throws MessagingException
    {
        if (customMessageId == null || customMessageId.trim().length() == 0)
        {
            // Let the super class create a unique Message-ID
            super.updateMessageID();
        }
        else
        {
            // use the provided Message-ID
            setHeader("Message-ID", "<" + customMessageId + ">");
        }
    }
}
