package com.atlassian.mail;

import com.atlassian.mail.config.ConfigLoader;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.util.concurrent.ResettableLazyReference;

public class MailFactory
{
    /**
     * @deprecated since 2.5.0. Use {@link Settings#ATLASSIAN_MAIL_SEND_DISABLED_SYSTEM_PROPERTY_KEY} instead.
     */
    @Deprecated
    public static final String MAIL_DISABLED_KEY = "atlassian.mail.senddisabled";

    private static final ResettableLazyReference<MailServerManager> serverManager =
            new ResettableLazyReference<MailServerManager>()
            {
                @Override
                protected MailServerManager create() throws Exception
                {
                    return ConfigLoader.getServerManager();
                }
            };

    private static final ResettableLazyReference<Settings> settings = new ResettableLazyReference<Settings>()
    {
        @Override
        protected Settings create() throws Exception
        {
            return ConfigLoader.getSettings();
        }
    };

    public static void refresh()
    {
        serverManager.reset();
        settings.reset();
    }

    public static MailServerManager getServerManager()
    {
        return serverManager.get();
    }

    public static Settings getSettings()
    {
        return settings.get();
    }

    /**
     * @deprecated since 2.5.0. Use {@link com.atlassian.mail.Settings#isSendingDisabled()} instead
     */
    @Deprecated
    public static boolean isSendingDisabled()
    {
        return getSettings().isSendingDisabled();
    }
}