/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail;

import com.atlassian.core.user.UserUtils;
import com.atlassian.mail.HtmlToTextConverter;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.User;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

public class MailUtils {
    static final int BUFFER_SIZE = 65536;
    static final String MULTIPART_ALTERNATE_CONTENT_TYPE = "multipart/alternative";
    static final String TEXT_CONTENT_TYPE = "text/plain";
    static final String HTML_CONTENT_TYPE = "text/html";
    private static final HtmlToTextConverter htmlConverter = new HtmlToTextConverter();
    private static final Category log = Category.getInstance((Class)MailUtils.class);

    public static InternetAddress[] parseAddresses(String addresses) throws AddressException {
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        list.clear();
        StringTokenizer st = new StringTokenizer(addresses, ", ");
        while (st.hasMoreTokens()) {
            list.add(new InternetAddress(st.nextToken()));
        }
        return list.toArray(new InternetAddress[list.size()]);
    }

    public static String getBody(Message message) throws MessagingException {
        String contentType = message.getContentType();
        try {
            String content;
            if (contentType != null && contentType.toLowerCase().startsWith(TEXT_CONTENT_TYPE)) {
                return (String)message.getContent();
            }
            if (contentType != null && contentType.toLowerCase().startsWith(HTML_CONTENT_TYPE)) {
                return new HtmlToTextConverter().convert((String)message.getContent());
            }
            if (message.getContent() instanceof Multipart && (content = MailUtils.getBodyFromMultipart((Multipart)message.getContent())) != null) {
                return content;
            }
            log.info((Object)"Could not find any body to extract from the message");
            return null;
        }
        catch (ClassCastException cce) {
            log.info((Object)("Exception getting the content type of message - probably not of type 'String': " + cce.getMessage()));
            return null;
        }
        catch (IOException e) {
            log.info((Object)("IOException whilst getting message content " + e.getMessage()));
            return null;
        }
    }

    public static Attachment[] getAttachments(Message message) throws MessagingException, IOException {
        ArrayList attachments = new ArrayList();
        if (message.getContent() instanceof Multipart) {
            MailUtils.addAttachments(attachments, (Multipart)message.getContent());
        }
        return attachments.toArray(new Attachment[attachments.size()]);
    }

    private static void addAttachments(List attachments, Multipart parts) throws MessagingException, IOException {
        int n = parts.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = parts.getBodyPart(i);
            if (MailUtils.isAttachment(part)) {
                InputStream content = part.getInputStream();
                String contentType = part.getContentType();
                attachments.add(new Attachment(contentType, part.getFileName(), MailUtils.toByteArray(content)));
                continue;
            }
            if (!(part.getContent() instanceof Multipart)) continue;
            MailUtils.addAttachments(attachments, (Multipart)part.getContent());
        }
    }

    private static boolean isAttachment(BodyPart part) throws MessagingException {
        return "attachment".equals(part.getDisposition()) || "inline".equals(part.getDisposition());
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while ((count = in.read(buf)) != -1) {
            out.write(buf, 0, count);
        }
        out.close();
        return out.toByteArray();
    }

    public static User getAuthorFromSender(Message message) throws MessagingException {
        return MailUtils.getFirstValidUser(message.getFrom());
    }

    public static User getFirstValidUser(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        for (int i = 0; i < addresses.length; ++i) {
            if (!(addresses[i] instanceof InternetAddress)) continue;
            InternetAddress email = (InternetAddress)addresses[i];
            try {
                User validUser = UserUtils.getUserByEmail((String)email.getAddress());
                return validUser;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean hasRecipient(String matchEmail, Message message) throws MessagingException {
        Address[] addresses = message.getAllRecipients();
        if (addresses == null || addresses.length == 0) {
            return false;
        }
        for (int i = 0; i < addresses.length; ++i) {
            InternetAddress email = (InternetAddress)addresses[i];
            if (matchEmail.compareToIgnoreCase(email.getAddress()) != 0) continue;
            return true;
        }
        return false;
    }

    public static List getSenders(Message message) throws MessagingException {
        ArrayList<String> senders = new ArrayList<String>();
        Address[] addresses = message.getFrom();
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                InternetAddress addr;
                String emailAddress;
                if (!(addresses[i] instanceof InternetAddress) || (emailAddress = StringUtils.trimToNull((String)(addr = (InternetAddress)addresses[i]).getAddress())) == null) continue;
                senders.add(emailAddress);
            }
        }
        return senders;
    }

    public static MimeBodyPart createAttachmentMimeBodyPart(String path) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(path);
        attachmentPart.setDataHandler(new DataHandler((DataSource)source));
        String fileName = MailUtils.extractFilenameFromPath(path);
        attachmentPart.setFileName(fileName);
        return attachmentPart;
    }

    private static String extractFilenameFromPath(String path) {
        String fileName;
        if (path == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(path, "\\/");
        do {
            fileName = st.nextToken();
        } while (st.hasMoreTokens());
        return fileName;
    }

    public static MimeBodyPart createZippedAttachmentMimeBodyPart(String path) throws MessagingException {
        File tmpFile = null;
        String fileName = MailUtils.extractFilenameFromPath(path);
        try {
            tmpFile = File.createTempFile("atlassian", null);
            FileOutputStream fout = new FileOutputStream(tmpFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            zout.putNextEntry(new ZipEntry(fileName));
            FileInputStream in = new FileInputStream(path);
            byte[] buffer = new byte[65536];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buffer))) {
                zout.write(buffer, 0, n);
            }
            zout.close();
            ((InputStream)in).close();
            log.debug((Object)("Wrote temporary zip of attachment to " + tmpFile));
        }
        catch (FileNotFoundException e) {
            String err = "Couldn't find file '" + path + "' on server: " + e;
            log.error((Object)err, (Throwable)e);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(err);
            return mimeBodyPart;
        }
        catch (IOException e) {
            String err = "Error zipping log file '" + path + "' on server: " + e;
            log.error((Object)err, (Throwable)e);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(err);
            return mimeBodyPart;
        }
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(tmpFile);
        attachmentPart.setDataHandler(new DataHandler((DataSource)source));
        attachmentPart.setFileName(fileName + ".zip");
        attachmentPart.setHeader("Content-Type", "application/zip");
        return attachmentPart;
    }

    private static String getBodyFromMultipart(Multipart multipart) throws MessagingException, IOException {
        StringBuffer sb = new StringBuffer();
        MailUtils.getBodyFromMultipart(multipart, sb);
        return sb.toString();
    }

    private static void getBodyFromMultipart(Multipart multipart, StringBuffer sb) throws MessagingException, IOException {
        String multipartType = multipart.getContentType();
        if (multipartType != null && MailUtils.compareContentType(multipartType, MULTIPART_ALTERNATE_CONTENT_TYPE)) {
            BodyPart part = MailUtils.getFirstInlinePartWithMimeType(multipart, TEXT_CONTENT_TYPE);
            if (part != null) {
                MailUtils.extractContentFromBodyPart(part, sb, false);
            } else {
                part = MailUtils.getFirstInlinePartWithMimeType(multipart, HTML_CONTENT_TYPE);
                MailUtils.extractContentFromBodyPart(part, sb, true);
            }
            return;
        }
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = part.getContentType();
            if ("attachment".equals(part.getDisposition()) || contentType == null) continue;
            if (MailUtils.compareContentType(contentType, TEXT_CONTENT_TYPE)) {
                MailUtils.extractContentFromBodyPart(part, sb, false);
                continue;
            }
            if (MailUtils.compareContentType(contentType, HTML_CONTENT_TYPE)) {
                MailUtils.extractContentFromBodyPart(part, sb, true);
                continue;
            }
            if (!(part.getContent() instanceof Multipart)) continue;
            MailUtils.getBodyFromMultipart((Multipart)part.getContent(), sb);
        }
    }

    private static void extractContentFromBodyPart(BodyPart part, StringBuffer sb, boolean convertHtml) throws IOException, MessagingException {
        if (part == null) {
            return;
        }
        if (part.getContent() instanceof String) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (convertHtml) {
                sb.append(htmlConverter.convert((String)part.getContent()));
            } else {
                sb.append(part.getContent());
            }
        } else {
            log.error((Object)("Mail MIME part with Content-Type '" + part.getContentType() + "' actually of type " + part.getClass().getName()));
        }
    }

    private static BodyPart getFirstInlinePartWithMimeType(Multipart multipart, String mimeType) throws MessagingException {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = part.getContentType();
            if ("attachment".equals(part.getDisposition()) || contentType == null || !MailUtils.compareContentType(contentType, mimeType)) continue;
            return part;
        }
        return null;
    }

    private static boolean compareContentType(String contentType, String mimeType) {
        return contentType.toLowerCase().startsWith(mimeType);
    }

    public static class Attachment {
        private final String contentType;
        private final String fileName;
        private final byte[] contents;

        public Attachment(String contentType, String fileName, byte[] contents) {
            this.contentType = contentType;
            this.fileName = fileName;
            this.contents = contents;
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getContents() {
            return this.contents;
        }

        public String getFilename() {
            return this.fileName;
        }
    }
}

