/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.impl;

import alt.javax.mail.Message;
import alt.javax.mail.Session;
import alt.javax.mail.SessionImpl;
import alt.javax.mail.internet.MimeMessage;
import alt.javax.mail.internet.MimeMessageImpl;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.AbstractMailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.util.MessageCreator;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Category;

public class SMTPMailServerImpl
extends AbstractMailServer
implements SMTPMailServer {
    private static final Category log = Category.getInstance(SMTPMailServerImpl.class);
    private boolean isSessionServer;
    private String defaultFrom;
    private String prefix;
    private String jndiLocation;
    private boolean removePrecedence;
    private transient Session session;

    public SMTPMailServerImpl() {
    }

    public SMTPMailServerImpl(Long id, String name, String description, String from, String prefix, boolean isSession, String location, String username, String password) {
        this(id, name, description, from, prefix, isSession, MailConstants.DEFAULT_SMTP_PROTOCOL, location, "25", false, username, password);
    }

    public SMTPMailServerImpl(Long id, String name, String description, String from, String prefix, boolean isSession, MailProtocol protocol, String location, String smtpPort, boolean tlsRequired, String username, String password) {
        this(id, name, description, from, prefix, isSession, false, protocol, location, smtpPort, tlsRequired, username, password, 10000L);
    }

    public SMTPMailServerImpl(Long id, String name, String description, String from, String prefix, boolean isSession, MailProtocol protocol, String location, String smtpPort, boolean tlsRequired, String username, String password, long timeout) {
        this(id, name, description, from, prefix, isSession, false, protocol, location, smtpPort, tlsRequired, username, password, timeout);
    }

    public SMTPMailServerImpl(Long id, String name, String description, String from, String prefix, boolean isSession, boolean removePrecedence, MailProtocol protocol, String location, String smtpPort, boolean tlsRequired, String username, String password, long timeout) {
        super(id, name, description, protocol, location, smtpPort, username, password, timeout);
        this.setDefaultFrom(from);
        this.setPrefix(prefix);
        this.setSessionServer(isSession);
        this.setRemovePrecedence(removePrecedence);
        this.setTlsRequired(tlsRequired);
        if (isSession) {
            this.setJndiLocation(location);
            this.setHostname(null);
        }
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    public void setJndiLocation(String jndiLocation) {
        this.jndiLocation = jndiLocation;
        this.propertyChanged();
    }

    protected Authenticator getAuthenticator() {
        return new MyAuthenticator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Session getSession() throws NamingException, MailException {
        if (this.session != null) return this.session;
        if (this.isSessionServer()) {
            Object jndiSession = this.getJndiSession();
            if (jndiSession instanceof javax.mail.Session) {
                this.session = new SessionImpl((javax.mail.Session)jndiSession);
                return this.session;
            }
            log.error((Object)("Mail server at location [" + this.getJndiLocation() + "] is not of required type javax.mail.Session, or is in different classloader. " + "It is of type '" + (jndiSession != null ? jndiSession.getClass().getName() : null) + "' in classloader '" + jndiSession.getClass().getClassLoader() + "' instead"));
            throw new IllegalArgumentException("Mail server at location [" + this.getJndiLocation() + "] is not of required type javax.mail.Session. ");
        }
        Properties props = this.loadSystemProperties(this.getProperties());
        Authenticator auth = this.isAuthenticating ? this.getAuthenticator() : null;
        this.session = MailFactory.getServerManager().getSession(props, auth);
        if (this.getDebugStream() == null) return this.session;
        try {
            this.session.getWrappedSession().setDebugOut(this.getDebugStream());
            return this.session;
        }
        catch (NoSuchMethodError nsme) {
            log.error((Object)"Warning: An old (pre-1.3.2) version of the JavaMail library (javamail.jar or mail.jar) bundled with your app server, is in use. Some functions such as IMAPS/POPS/SMTPS will not work. Consider upgrading the app server's javamail jar to the version JIRA provides.");
        }
        return this.session;
    }

    protected Object getJndiSession() throws NamingException {
        InitialContext ctx = new InitialContext();
        Object jndiSession = ctx.lookup(this.getJndiLocation());
        return jndiSession;
    }

    public void send(Email email) throws MailException {
        try {
            Session thisSession = this.getSession();
            MimeMessageImpl message = new MimeMessageImpl(thisSession);
            MessageCreator messageCreator = new MessageCreator();
            messageCreator.updateMimeMessage(email, this.getDefaultFrom(), this.prefix, (MimeMessage)message);
            thisSession.getTransport(this.getMailProtocol().getProtocol()).send((Message)message);
            if (message.getHeader("Message-Id") != null && message.getHeader("Message-Id").length > 0) {
                email.setMessageId(message.getHeader("Message-Id")[0]);
            }
        }
        catch (NamingException e) {
            throw new MailException(e);
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)"Error setting the 'from' address with an email and the user's fullname");
            e.printStackTrace();
        }
    }

    public void quietSend(Email email) throws MailException {
        try {
            this.send(email);
        }
        catch (Exception e) {
            log.error((Object)("Error sending mail. to:" + email.getTo() + ", cc:" + email.getCc() + ", bcc:" + email.getBcc() + ", subject:" + email.getSubject() + ", body:" + email.getBody() + ", mimeType:" + email.getMimeType() + ", encoding:" + email.getEncoding() + ", multipart:" + email.getMultipart() + ", error:" + e), (Throwable)e);
        }
    }

    public String getType() {
        return MailServerManager.SERVER_TYPES[1];
    }

    public String getDefaultFrom() {
        return this.defaultFrom;
    }

    public void setDefaultFrom(String defaultFrom) {
        this.defaultFrom = defaultFrom;
        this.propertyChanged();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRemovePrecedence() {
        return this.removePrecedence;
    }

    public void setRemovePrecedence(boolean precedence) {
        this.removePrecedence = precedence;
        this.propertyChanged();
    }

    public boolean isSessionServer() {
        return this.isSessionServer;
    }

    public void setSessionServer(boolean sessionServer) {
        this.isSessionServer = sessionServer;
        this.propertyChanged();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SMTPMailServerImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SMTPMailServerImpl smtpMailServer = (SMTPMailServerImpl)o;
        if (this.isSessionServer != smtpMailServer.isSessionServer) {
            return false;
        }
        if (this.defaultFrom != null ? !this.defaultFrom.equals(smtpMailServer.defaultFrom) : smtpMailServer.defaultFrom != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(smtpMailServer.prefix) : smtpMailServer.prefix != null) {
            return false;
        }
        return this.removePrecedence == smtpMailServer.removePrecedence;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.isSessionServer ? 1 : 0);
        result = 29 * result + (this.defaultFrom != null ? this.defaultFrom.hashCode() : 0);
        result = 29 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 29 * result + (this.removePrecedence ? 1 : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("description", (Object)this.getDescription()).append("server name", (Object)this.getHostname()).append("username", (Object)this.getUsername()).append("password", (Object)this.getPassword()).append("isSessionServer", this.isSessionServer).append("defaultFrom", (Object)this.defaultFrom).append("prefix", (Object)this.prefix).append("smtpPort", (Object)this.getPort()).toString();
    }

    protected void propertyChanged() {
        super.propertyChanged();
        this.session = null;
    }

    private class MyAuthenticator
    extends Authenticator {
        private MyAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(SMTPMailServerImpl.this.getUsername(), SMTPMailServerImpl.this.getPassword());
        }
    }
}

