/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server;

import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Category;

public abstract class AbstractMailServer
implements MailServer,
Serializable {
    protected transient Category LOG = Category.getInstance(this.getClass());
    private Long id;
    private String name;
    private String description;
    private String hostname;
    private String username = null;
    private String password = null;
    private MailProtocol mailProtocol = null;
    private String port = null;
    private long timeout;
    private boolean debug;
    private boolean tlsRequired;
    private transient PrintStream debugStream;
    private Properties props = new Properties();
    protected boolean isAuthenticating;

    public AbstractMailServer() {
    }

    public AbstractMailServer(Long id, String name, String description, MailProtocol protocol, String hostName, String port, String username, String password, long timeout) {
        this.setId(id);
        this.setName(name);
        this.setDescription(description);
        this.setHostname(hostName);
        this.setUsername(username);
        this.setPassword(password);
        this.setMailProtocol(protocol);
        this.setPort(port);
        this.setTimeout(timeout);
    }

    private void setInitialProperties() {
        if (this.getMailProtocol() != null) {
            String protocol = this.getMailProtocol().getProtocol();
            this.props.put("mail." + protocol + ".host", "" + this.getHostname());
            this.props.put("mail." + protocol + ".port", "" + this.getPort());
            this.props.put("mail." + protocol + ".timeout", "" + this.getTimeout());
            this.props.put("mail.transport.protocol", "" + protocol);
            if (this.isTlsRequired()) {
                this.props.put("mail." + protocol + ".starttls.enable", "true");
            }
            if (StringUtils.isNotBlank((String)this.getUsername())) {
                this.props.put("mail." + protocol + ".auth", "true");
                this.isAuthenticating = true;
            }
        }
        this.props.put("mail.debug", "" + this.getDebug());
        if (Boolean.getBoolean("mail.debug")) {
            this.props.put("mail.debug", "true");
        }
    }

    protected abstract Authenticator getAuthenticator();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.propertyChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.propertyChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.propertyChanged();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String serverName) {
        this.hostname = serverName;
        this.propertyChanged();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = StringUtils.isNotBlank((String)username) ? username : null;
        this.propertyChanged();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isNotBlank((String)password) ? password : null;
        this.propertyChanged();
    }

    public MailProtocol getMailProtocol() {
        return this.mailProtocol;
    }

    public void setMailProtocol(MailProtocol protocol) {
        this.mailProtocol = protocol;
        this.propertyChanged();
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
        this.propertyChanged();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        this.propertyChanged();
    }

    public boolean isTlsRequired() {
        return this.tlsRequired;
    }

    public void setTlsRequired(boolean tlsRequired) {
        this.tlsRequired = tlsRequired;
        this.propertyChanged();
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties props) {
        this.props = props;
        this.propertyChanged();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.propertyChanged();
    }

    public void setDebugStream(PrintStream debugStream) {
        this.debugStream = debugStream;
        this.propertyChanged();
    }

    public boolean getDebug() {
        return this.debug;
    }

    public PrintStream getDebugStream() {
        return this.debugStream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractMailServer)) {
            return false;
        }
        AbstractMailServer abstractMailServer = (AbstractMailServer)o;
        return new EqualsBuilder().append((Object)this.id, (Object)abstractMailServer.id).append((Object)this.name, (Object)abstractMailServer.name).append((Object)this.description, (Object)abstractMailServer.description).append((Object)this.hostname, (Object)abstractMailServer.hostname).append((Object)this.username, (Object)abstractMailServer.username).append((Object)this.password, (Object)abstractMailServer.password).append((Object)this.mailProtocol, (Object)abstractMailServer.mailProtocol).append((Object)this.port, (Object)abstractMailServer.port).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.name).append((Object)this.description).append((Object)this.hostname).append((Object)this.username).append((Object)this.password).append((Object)this.mailProtocol).append((Object)this.port).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("description", (Object)this.description).append("server name", (Object)this.hostname).append("username", (Object)this.username).append("password", (Object)this.password).toString();
    }

    protected void propertyChanged() {
        this.setInitialProperties();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.LOG = Category.getInstance(this.getClass());
    }

    protected synchronized Properties loadSystemProperties(Properties p) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)p);
        props.putAll((Map<?, ?>)System.getProperties());
        if (this.props != null) {
            props.putAll((Map<?, ?>)this.props);
        }
        return props;
    }
}

