/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.queue;

import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailQueueImpl
implements MailQueue {
    private static final Category log = Category.getInstance(MailQueueImpl.class);
    private static final int MAX_SEND_ATTEMPTS = 10;
    private Queue<MailQueueItem> items = new PriorityBlockingQueue<MailQueueItem>();
    private Queue<MailQueueItem> errorItems = new PriorityBlockingQueue<MailQueueItem>();
    private boolean sending;
    private MailQueueItem itemBeingSent;
    private Timestamp sendingStarted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBuffer() {
        if (this.sending) {
            log.warn((Object)("Already sending " + this.items.size() + " mails:"));
            for (MailQueueItem item : this.items) {
                log.warn((Object)("Queued to send: " + item + ", " + item.getClass()));
            }
            return;
        }
        this.sendingStarted();
        ArrayList<MailQueueItem> failed = new ArrayList<MailQueueItem>();
        try {
            while (!this.items.isEmpty()) {
                MailQueueItem item;
                String origThreadName = Thread.currentThread().getName();
                this.itemBeingSent = item = this.items.poll();
                log.debug((Object)("Sending: " + item));
                try {
                    Thread.currentThread().setName("Sending mailitem " + item);
                    item.send();
                }
                catch (MailException e) {
                    if (item.getSendCount() > 10) {
                        this.errorItems.add(item);
                    } else {
                        failed.add(item);
                    }
                    log.error((Object)("Error occurred in sending e-mail: " + item), (Throwable)((Object)e));
                }
                finally {
                    Thread.currentThread().setName(origThreadName);
                }
            }
            this.items.addAll(failed);
        }
        finally {
            this.sendingStopped();
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public int errorSize() {
        return this.errorItems.size();
    }

    @Override
    public void addItem(MailQueueItem item) {
        log.debug((Object)("Queued: " + item));
        this.items.add(item);
    }

    @Override
    public void addErrorItem(MailQueueItem item) {
        log.debug((Object)("Queued error: " + item));
        this.errorItems.add(item);
    }

    @Override
    public Queue<MailQueueItem> getQueue() {
        return this.items;
    }

    @Override
    public Queue<MailQueueItem> getErrorQueue() {
        return this.errorItems;
    }

    @Override
    public boolean isSending() {
        return this.sending;
    }

    @Override
    public Timestamp getSendingStarted() {
        return this.sendingStarted;
    }

    @Override
    public MailQueueItem getItemBeingSent() {
        return this.itemBeingSent;
    }

    @Override
    public void unstickQueue() {
        log.error((Object)("Mail on queue was considered stuck: " + this.itemBeingSent));
        this.sendingStopped();
    }

    @Override
    public void emptyErrorQueue() {
        this.errorItems.clear();
    }

    @Override
    public void resendErrorQueue() {
        this.items.addAll(this.errorItems);
        this.emptyErrorQueue();
    }

    public void sendingStarted() {
        this.sending = true;
        this.sendingStarted = new Timestamp(System.currentTimeMillis());
    }

    public void sendingStopped() {
        this.sending = false;
        this.sendingStarted = null;
    }
}

