/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.queue;

import com.atlassian.mail.MailThreader;
import com.atlassian.mail.queue.MailQueueItem;
import java.util.Date;

public abstract class AbstractMailQueueItem
implements MailQueueItem {
    String subject;
    Date dateQueued = new Date();
    private int timesSent = 0;
    protected MailThreader mailThreader;

    public AbstractMailQueueItem() {
    }

    public AbstractMailQueueItem(String subject) {
        this();
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getDateQueued() {
        return this.dateQueued;
    }

    public int getSendCount() {
        return this.timesSent;
    }

    public boolean hasError() {
        return this.timesSent > 0;
    }

    protected void incrementSendCount() {
        ++this.timesSent;
    }

    public void setMailThreader(MailThreader mailThreader) {
        this.mailThreader = mailThreader;
    }

    public void execute() throws Exception {
        this.send();
    }

    public final int compareTo(MailQueueItem o) {
        int priorityComparator = new Integer(this.timesSent).compareTo(o.getSendCount());
        return priorityComparator == 0 ? this.dateQueued.compareTo(o.getDateQueued()) : priorityComparator;
    }
}

