package com.atlassian.lesscss.spi;

import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import com.atlassian.webresource.api.prebake.Coordinate;

import javax.annotation.Nonnull;
import java.net.URI;
import java.util.Optional;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Encapsulates the result of {@link DimensionAwareUriResolver#encodeState(URI, Coordinate)} .
 */
public class EncodeStateResult {

    private final String state;
    private final Optional<PrebakeError> prebakeError;

    public EncodeStateResult(@Nonnull String state, @Nonnull Optional<PrebakeError> prebakeError) {
        this.state = checkNotNull(state);
        this.prebakeError = checkNotNull(prebakeError);
    }

    public String getState() {
        return state;
    }

    public Optional<PrebakeError> getPrebakeError() {
        return prebakeError;
    }
}
