/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.watch.nio.file.internal.jwatch;

import com.atlassian.watch.nio.file.api.Paths;
import com.atlassian.watch.nio.file.api.StandardWatchEventKinds;
import com.atlassian.watch.nio.file.api.WatchEvent;
import com.atlassian.watch.nio.file.internal.Underlying;
import java.util.HashMap;
import java.util.Map;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.impl.PathWatchEventModifier;

public class WatchEventImpl<T>
implements com.atlassian.watch.nio.file.api.WatchEvent<T>,
Underlying<WatchEvent> {
    private final WatchEvent<T> impl;

    public WatchEventImpl(WatchEvent<T> impl) {
        this.impl = impl;
    }

    @Override
    public WatchEvent underlying() {
        return this.impl;
    }

    @Override
    public T context() {
        Object path = this.impl.context();
        return (T)(path == null ? null : Paths.toPath(path.toString()));
    }

    @Override
    public int count() {
        return this.impl.count();
    }

    @Override
    public WatchEvent.Kind<T> kind() {
        return KindImpl.unmap(this.impl.kind());
    }

    public boolean equals(Object obj) {
        return obj instanceof Underlying && this.impl.equals(((Underlying)obj).underlying());
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public String toString() {
        return this.impl.toString();
    }

    public static class ModifierImpl
    implements WatchEvent.Modifier,
    Underlying<WatchEvent.Modifier> {
        private final WatchEvent.Modifier impl;

        public ModifierImpl(WatchEvent.Modifier modifier) {
            this.impl = new PathWatchEventModifier(modifier.name());
        }

        static WatchEvent.Modifier map(WatchEvent.Modifier modifier) {
            return new PathWatchEventModifier(modifier.name());
        }

        @Override
        public WatchEvent.Modifier underlying() {
            return this.impl;
        }

        @Override
        public String name() {
            return this.impl.name();
        }
    }

    public static class KindImpl
    implements WatchEvent.Kind,
    Underlying<WatchEvent.Kind> {
        private static Map<WatchEvent.Kind, WatchEvent.Kind> map = new HashMap<WatchEvent.Kind, WatchEvent.Kind>();
        private final WatchEvent.Kind impl;

        KindImpl(WatchEvent.Kind kind) {
            this.impl = kind;
        }

        static WatchEvent.Kind map(WatchEvent.Kind kind) {
            WatchEvent.Kind theKind = map.get(kind);
            if (theKind == null) {
                throw new IllegalStateException("Could find kind " + kind.name());
            }
            return theKind;
        }

        public static <T> WatchEvent.Kind<T> unmap(WatchEvent.Kind kind) {
            for (Map.Entry<WatchEvent.Kind, WatchEvent.Kind> entry : map.entrySet()) {
                if (entry.getValue() != kind) continue;
                return entry.getKey();
            }
            throw new IllegalStateException("Could find kind " + kind.name());
        }

        @Override
        public WatchEvent.Kind underlying() {
            return this.impl;
        }

        @Override
        public String name() {
            return this.impl.name();
        }

        public Class type() {
            return this.impl.type();
        }

        static {
            map.put(StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKind.ENTRY_CREATE);
            map.put(StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKind.ENTRY_DELETE);
            map.put(StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKind.ENTRY_MODIFY);
            map.put(StandardWatchEventKinds.OVERFLOW, StandardWatchEventKind.OVERFLOW);
        }
    }
}

