/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.servlet;

import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.StateManager;
import com.atlassian.labs.plugins.quickreload.SystemProperties;
import com.atlassian.labs.plugins.quickreload.WittyQuoter;
import com.atlassian.labs.plugins.quickreload.utils.VersionKit;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class ControlPanelServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ControlPanelServlet.class);
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final DirectoryTracker directoryTracker;
    private final WebResourceManager webResourceManager;
    private final StateManager stateManager;
    private final WittyQuoter wittyQuoter;

    public ControlPanelServlet(@ComponentImport SoyTemplateRenderer soyTemplateRenderer, DirectoryTracker directoryTracker, @ComponentImport WebResourceManager webResourceManager, StateManager stateManager, WittyQuoter wittyQuoter) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.directoryTracker = directoryTracker;
        this.webResourceManager = webResourceManager;
        this.stateManager = stateManager;
        this.wittyQuoter = wittyQuoter;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws IOException {
        try {
            this.webResourceManager.requireResource("com.atlassian.labs.plugins.quickreload.reloader:qr-control-panel-resources");
            response.setContentType("text/html; charset=utf-8");
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), "com.atlassian.labs.plugins.quickreload.reloader:qr-control-panel-resources", "QuickReload.Page.ControlPanel.main", this.getRenderParams(req));
        }
        catch (SoyException e) {
            log.error("Failed to render template for QuickReload control panel", (Throwable)e);
        }
    }

    private Map<String, Object> getRenderParams(HttpServletRequest req) {
        Map<String, String> quickReloadManagedProperties = this.stateManager.getBatchingSystemPropertyStates();
        LinkedHashMap<String, Object> builder = new LinkedHashMap<String, Object>();
        builder.put("trackedDirectories", this.getTrackedDirectories());
        builder.put("trackedPluginResourceDirectories", this.getPluginResourceDirectories());
        builder.put("systemPropertyStates", quickReloadManagedProperties);
        builder.put("isBatchedMode", this.stateManager.isBatchingEnabled());
        builder.put("apiLinkBase", this.getApiLink(req));
        builder.put("qrVersion", VersionKit.getDisplayedVersion());
        builder.put("wit", this.wittyQuoter.halfWit());
        return Collections.unmodifiableMap(builder);
    }

    private List<String> getTrackedDirectories() {
        ArrayList<String> trackedDirectories = new ArrayList<String>();
        for (File trackedDirectory : this.directoryTracker.getTracked()) {
            trackedDirectories.add(trackedDirectory.getAbsolutePath());
        }
        return trackedDirectories;
    }

    private List<String> getPluginResourceDirectories() {
        return new ArrayList<String>(SystemProperties.getSystemPropertySplit("plugin.resource.directories", ","));
    }

    public String getApiLink(HttpServletRequest req) {
        return String.format("%s://%s:%s%s/rest/qr", req.getScheme(), req.getServerName(), req.getServerPort(), req.getContextPath());
    }
}

