/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.DirectoryWatcher;
import com.atlassian.labs.plugins.quickreload.install.PluginInstaller;
import com.atlassian.labs.plugins.quickreload.rest.Links;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json", "text/plain", "application/x-www-form-urlencoded"})
@Path(value="/plugin")
public class PluginRestResource {
    private static final Logger log = LoggerFactory.getLogger(PluginRestResource.class);
    private final PluginInstaller pluginInstaller;
    private final DirectoryTracker directoryTracker;
    private final DirectoryWatcher directoryWatcher;

    @Inject
    public PluginRestResource(PluginInstaller pluginInstaller, DirectoryTracker directoryTracker, DirectoryWatcher directoryWatcher) {
        this.pluginInstaller = pluginInstaller;
        this.directoryTracker = directoryTracker;
        this.directoryWatcher = directoryWatcher;
    }

    @GET
    @Path(value="/enabled/{pluginKey}")
    public Response enabled(@PathParam(value="pluginKey") String pluginKey, @Context UriInfo uriInfo) {
        try {
            boolean isEnabled = this.pluginInstaller.pluginEnabled(pluginKey);
            Response.Status status = Response.Status.OK;
            if (!isEnabled) {
                status = Response.Status.NOT_FOUND;
            }
            Links.PluginLinks links = this.createLinks(pluginKey, uriInfo);
            PluginState entity = new PluginState(pluginKey, isEnabled, links, this.api(uriInfo));
            return Response.status((Response.Status)status).entity((Object)entity).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (RuntimeException e) {
            return this.exceptionResponse(uriInfo, e);
        }
    }

    @POST
    @Path(value="/enabled/{pluginKey}")
    public Response enable(@PathParam(value="pluginKey") String pluginKey, @Context UriInfo uriInfo) {
        try {
            this.pluginInstaller.enablePlugin(pluginKey);
            return this.enabled(pluginKey, uriInfo);
        }
        catch (RuntimeException e) {
            return this.exceptionResponse(uriInfo, e);
        }
    }

    @DELETE
    @Path(value="/enabled/{pluginKey}")
    public Response disable(@PathParam(value="pluginKey") String pluginKey, @Context UriInfo uriInfo) {
        try {
            this.pluginInstaller.disablePlugin(pluginKey);
            return this.enabled(pluginKey, uriInfo);
        }
        catch (RuntimeException e) {
            return this.exceptionResponse(uriInfo, e);
        }
    }

    @POST
    @Path(value="/install/{fullPathToPlugin : .+?}")
    public Response install(@PathParam(value="fullPathToPlugin") String fullPathToPlugin, @Context UriInfo uriInfo) {
        return this.installPlugin(fullPathToPlugin, uriInfo);
    }

    @DELETE
    @Path(value="/install/{pluginKey}")
    public Response uninstall(@PathParam(value="pluginKey") String pluginKey, @Context UriInfo uriInfo) {
        Links.ApiLinks api = this.api(uriInfo);
        try {
            this.pluginInstaller.uninstallPlugin(pluginKey);
            return Response.ok().entity((Object)api).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (RuntimeException e) {
            log.error(String.format("Unable to uninstall '%s'", pluginKey), (Throwable)e);
            if (e instanceof IllegalArgumentException) {
                UnInstalled unInstalled = new UnInstalled(api, pluginKey, "plugin key not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)unInstalled).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            UnInstalled unInstalled = new UnInstalled(api, pluginKey, e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)unInstalled).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    private Links.PluginLinks createLinks(String pluginKey, UriInfo uriInfo) {
        return Links.PluginLinks.builder(uriInfo).withPluginKey(pluginKey).build();
    }

    private Response exceptionResponse(UriInfo uriInfo, Exception exception) {
        ExceptionDTO exceptionDTO = new ExceptionDTO(this.api(uriInfo), exception);
        return Response.serverError().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)exceptionDTO).build();
    }

    private Links.ApiLinks api(UriInfo uriInfo) {
        return Links.ApiLinks.builder(uriInfo).build();
    }

    private Response installPlugin(String plugin, UriInfo uriInfo) {
        Links.ApiLinks api = this.api(uriInfo);
        if (StringUtils.isEmpty((CharSequence)plugin)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)api).build();
        }
        File file = new File(plugin);
        if (!file.exists()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)api).build();
        }
        try {
            this.pluginInstaller.installPluginImmediately(file);
            File trackedDir = file.getParentFile();
            this.directoryTracker.add(trackedDir.getAbsolutePath());
            this.directoryWatcher.watch(trackedDir);
            Installed installed = new Installed(api, file.getAbsolutePath());
            return Response.ok((Object)installed, (String)"application/json").build();
        }
        catch (Exception e) {
            String pluginFile = file.getAbsolutePath();
            log.error(String.format("Unable to install '%s'", pluginFile), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Installed(api, pluginFile, e.toString())).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    static class UnInstalled {
        public final Links.ApiLinks api;
        public final String pluginKey;
        public final String error;

        UnInstalled(Links.ApiLinks api, String pluginKey, String error) {
            this.api = api;
            this.pluginKey = pluginKey;
            this.error = error;
        }
    }

    static class Installed {
        public final String installed;
        public final String error;
        public final Links.ApiLinks api;

        Installed(Links.ApiLinks api, String installed) {
            this.api = api;
            this.installed = installed;
            this.error = null;
        }

        Installed(Links.ApiLinks api, String installed, String error) {
            this.api = api;
            this.installed = installed;
            this.error = error;
        }
    }

    static class PluginState {
        public final boolean enabled;
        public final String key;
        public final Links.PluginLinks links;
        public final Links.ApiLinks api;

        PluginState(String key, boolean enabled, Links.PluginLinks links, Links.ApiLinks api) {
            this.key = key;
            this.enabled = enabled;
            this.links = links;
            this.api = api;
        }
    }

    static class ExceptionDTO {
        public final String error;
        public final String stackTrace;
        public final Links.ApiLinks api;

        ExceptionDTO(Links.ApiLinks api, Exception e) {
            this.api = api;
            this.error = e.toString();
            this.stackTrace = this.makeStackTrace(e);
        }

        private String makeStackTrace(Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
    }
}

