;(function($, AJS) {
    if(!$) {
        console.warn("Could not find jQuery, QuickReload batch mode switcher not enabled");
        return;
    }
    if(!AJS) {
        console.warn("Could not find AJS, QuickReload batch mode switcher not enabled");
        return;
    }
    if(!$.isFunction(AJS.whenIType)) {
        console.warn("Could not find AJS.whenIType, QuickReload batch mode switcher not enabled");
        return;
    }

    //From underscore
    var debounce = function(func, wait, immediate) {
        var timeout, args, context, timestamp, result;

        var later = function() {
            var last = Date.now() - timestamp;

            if (last < wait && last >= 0) {
                timeout = setTimeout(later, wait - last);
            } else {
                timeout = null;
                if (!immediate) {
                    result = func.apply(context, args);
                    if (!timeout) context = args = null;
                }
            }
        };

        return function() {
            context = this;
            args = arguments;
            timestamp = Date.now();
            var callNow = immediate && !timeout;
            if (!timeout) timeout = setTimeout(later, wait);
            if (callNow) {
                result = func.apply(context, args);
                context = args = null;
            }

            return result;
        };
    };

    var searchForContextPath = function() {
        if($.isFunction(AJS.contextPath)) {
            return AJS.contextPath();
        } else if (AJS.Meta && $.isFunction(AJS.Meta.get)) {
            try {
                return AJS.Meta.get("context-path");
            } catch(ignored) {}
        }

        return null;
    };

    var getCurrentBatchModeStateUrl = function(contextPath) {
        return contextPath + "/rest/qr/1.0/batching";
    };

    var getUpdateBatchModeUrl = function(contextPath, enableBatching) {
        return contextPath + "/rest/qr/1.0/batching/setState?enabled=" + !!enableBatching;
    };

    var tryGrabAuiFlag = function() {
        try {
            if($.isFunction(require)) {
                return require("aui/flag");
            }
        } catch(notFoundException) {}

        return null;
    };

    var getToastSuccessTitle = function(newBatchedModeState) {
        if(!!newBatchedModeState) {
            return "Production mode";
        } else {
            return "Dev mode";
        }
    };

    var getToastSuccessMessageHtml = function(newBatchedModeState) {
        if(!!newBatchedModeState) {
            return "Web resource batching and caching enabled";
        } else {
            return "Disabled web resource batching and caching";
        }
    };

    var toastSuccess = function(title, messageHtml) {
        toastMessage(title, messageHtml, true);
    };

    var toastError = function(title, messageHtml) {
        toastMessage(title, messageHtml, false);
    };

    var messageId = "quickreload-flag";
    var toastMessage = function(title, messageHtml, isSuccess) {
        var auiFlag = tryGrabAuiFlag();
        if(auiFlag) {
            auiFlag({
                type: !!isSuccess ? "success" : "error",
                title: title,
                body: messageHtml,
                persistent: false,
                close: "auto"
            });
        } else if(AJS.messages && $.isFunction(AJS.messages.success)) {
            var messageFunc;
            if(!!isSuccess) {
                messageFunc = AJS.messages.success;
            } else {
                messageFunc = AJS.messages.error;
            }

            var $message = $(messageFunc.call(AJS.messages, {
                title: title,
                body: messageHtml,
                id: messageId,
                fadeout: true,
                delay: 3000
            }));

            $("#" + messageId).remove();
            $("body").append($message);
        } else {
            alert(title);
        }
    };

    $(function() {
        var contextPath = searchForContextPath();
        if(!contextPath) {
            console.warn("Failed to determine context path, QuickReload batch mode switcher not enabled");
            return;
        }

        var batchingEnabledState = false;
        //Fetch initial state
        $.get(getCurrentBatchModeStateUrl(contextPath)).done(function(data) {
            batchingEnabledState = data.batchingEnabled;
        });

        var debouncedToggleBatchingCallback = debounce(function() {
            $.get(getUpdateBatchModeUrl(contextPath, !batchingEnabledState))
                .done(function(data) {
                    batchingEnabledState = data.batchingEnabled;
                    var successTitle = getToastSuccessTitle(batchingEnabledState);
                    var successMessageHtml = getToastSuccessMessageHtml(batchingEnabledState);
                    toastSuccess(successTitle, successMessageHtml);
                })
                .fail(function(xhr, textStatus) {
                    if(textStatus !== "abort") {
                        var batchingStateStr = batchingEnabledState ? "enabled" : "disabled";
                        toastError("Failed to update batch mode state (current state: " + batchingStateStr + ")");
                    }

                });
        }, 2000, true);

        AJS.whenIType("b").execute(debouncedToggleBatchingCallback);
    });
})((AJS && AJS.$) || $, AJS);