/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.utils;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class Files {
    public static File smooshNames(String startingPath, String pathToAdd) {
        String smooshed = FilenameUtils.concat((String)startingPath, (String)pathToAdd);
        return new File(smooshed);
    }

    public static File smooshNames(File startingPath, String pathToAdd) {
        String smooshed = FilenameUtils.concat((String)startingPath.getAbsolutePath(), (String)pathToAdd);
        return new File(smooshed);
    }

    public static File smooshNames(File startingPath, File pathToAdd) {
        String smooshed = FilenameUtils.concat((String)startingPath.getAbsolutePath(), (String)pathToAdd.getAbsolutePath());
        return new File(smooshed);
    }

    public static void mkdirs(File file) {
        file.mkdirs();
    }

    public static File pwd() {
        return new File(new File("pwd").getAbsolutePath()).getParentFile();
    }

    public static void traverseUpLookingForFile(String fileName, File startingDir, Effect<File> sideEffect) {
        for (File dir = startingDir; dir != null; dir = dir.getParentFile()) {
            File file = Files.smooshNames(dir, fileName);
            if (!file.exists() || !file.isFile()) continue;
            sideEffect.apply((Object)file);
        }
    }

    public static Option<File> traverseUpForFileThenYouFindItAndTheCant(String fileName, File startingDir) {
        Option<File> found = Files.traverseUpTillItsFound(fileName, startingDir);
        if (found.isDefined()) {
            return Files.traverseUpTillItsNotThere((File)found.get());
        }
        return found;
    }

    private static Option<File> traverseUpTillItsFound(String fileName, File startingDir) {
        for (File dir = startingDir; dir != null; dir = dir.getParentFile()) {
            File file = Files.smooshNames(dir, fileName);
            if (!file.exists() || !file.isFile()) continue;
            return Option.some((Object)file);
        }
        return Option.none();
    }

    private static Option<File> traverseUpTillItsNotThere(File startingFile) {
        File file;
        Preconditions.checkArgument((startingFile.exists() && startingFile.isFile() ? 1 : 0) != 0);
        Option lastFile = Option.some((Object)startingFile);
        String desiredName = startingFile.getName();
        for (File dir = startingFile.getParentFile().getParentFile(); dir != null && (file = Files.smooshNames(dir, desiredName)).exists() && file.isFile(); dir = dir.getParentFile()) {
            lastFile = Option.some((Object)file);
        }
        return lastFile;
    }

    public static void traverseDownLookingForFile(String fileName, File startingDir, Effect<File> sideEffect) {
        Iterator iterator = FileUtils.iterateFiles((File)startingDir, (IOFileFilter)new NameFileFilter("pom.xml"), (IOFileFilter)TrueFileFilter.TRUE);
        while (iterator.hasNext()) {
            File next = (File)iterator.next();
            sideEffect.apply((Object)next);
        }
    }

    public static boolean directoryExists(File potentialDir) {
        return potentialDir.exists() && potentialDir.isDirectory();
    }

    public static boolean pathContainsDirectory(File file, String targetName) {
        for (File f = file; f != null; f = f.getParentFile()) {
            if (!f.isDirectory() || !f.getName().equals(targetName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAtlassianPlugin(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            ZipEntry entry = jar.getEntry("atlassian-plugin.xml");
            return entry != null && !entry.isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }
}

