/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.inspectors;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.labs.plugins.quickreload.inspectors.PluginBundle;
import com.atlassian.labs.plugins.quickreload.utils.ArrayKit;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.joor.Reflect;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;

@Named
public class BundleInspector {
    public static final Comparator<Bundle> BY_BUNDLE_ID = new Comparator<Bundle>(){

        @Override
        public int compare(Bundle o1, Bundle o2) {
            return Long.compare(o1.getBundleId(), o2.getBundleId());
        }
    };
    public static final Function<Object, String> TO_STRING_OR_NULL = new Function<Object, String>(){

        public String apply(Object from) {
            return from == null ? null : from.toString();
        }
    };
    public static final Comparator<Object> BY_STRING_VALUE_OF = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return String.valueOf(o1).compareTo(String.valueOf(o2));
        }
    };
    private static final String ATLASSIAN_PLUGIN_KEY = "Atlassian-Plugin-Key";
    private final BundleContext bundleContext;
    private final PluginAccessor pluginAccessor;

    @Inject
    public BundleInspector(BundleContext bundleContext, PluginAccessor pluginAccessor) {
        this.bundleContext = bundleContext;
        this.pluginAccessor = pluginAccessor;
    }

    public void inspectBundleServices(BundleServiceCallback callback) {
        HashSet seen = Sets.newHashSet();
        List<Bundle> bundles = ArrayKit.asList(this.bundleContext.getBundles());
        for (Bundle bundle : bundles) {
            List<ServiceRef> serviceRefs = this.inspectRegisteredServices(bundle);
            for (ServiceRef serviceRef : serviceRefs) {
                if (seen.contains(serviceRef.serviceId)) continue;
                seen.add(serviceRef.serviceId);
                callback.onBundle(this.newPluginBundle(bundle), serviceRef);
            }
        }
    }

    public void inspectBundles(BundleCallback bundleCallback) {
        List<Bundle> bundles = ArrayKit.asList(this.bundleContext.getBundles());
        Collections.sort(bundles, BY_BUNDLE_ID);
        for (Bundle bundle : bundles) {
            PluginBundle pluginBundle = this.newPluginBundle(bundle);
            bundleCallback.onBundle(pluginBundle);
        }
    }

    public void inspectBundle(long bundleId, BeanCallback beanCallback) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        if (bundle == null) {
            return;
        }
        PluginBundle pluginBundle = this.newPluginBundle(bundle);
        beanCallback.onStart(pluginBundle);
        List<ServiceReference> srs = this.getSpringContext(bundleId);
        for (ServiceReference sr : srs) {
            this.inspectSpringContext(beanCallback, this.bundleContext, sr);
        }
    }

    public Option<Plugin> inspectBundlePluginModules(long bundleId, PluginCallback callback) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        if (bundle == null) {
            return Option.none();
        }
        PluginBundle pluginBundle = this.newPluginBundle(bundle);
        Plugin plugin = this.pluginAccessor.getPlugin(pluginBundle.getPluginKey());
        if (plugin == null) {
            return Option.none();
        }
        for (ModuleDescriptor moduleDescriptor : plugin.getModuleDescriptors()) {
            callback.onModuleDescriptor(moduleDescriptor, this.pluginAccessor.isPluginModuleEnabled(moduleDescriptor.getCompleteKey()));
        }
        return Option.some((Object)plugin);
    }

    public boolean isSystemPlugin(Plugin plugin) {
        return this.pluginAccessor.isSystemPlugin(plugin.getKey());
    }

    public boolean isEnabled(Plugin plugin) {
        return this.pluginAccessor.isPluginEnabled(plugin.getKey());
    }

    public List<ServiceRef> inspectRegisteredServices(Bundle bundle) {
        List<ServiceReference> registeredSR = ArrayKit.asList(bundle.getRegisteredServices());
        return this.getServiceRefs(registeredSR);
    }

    public List<ServiceRef> inspectServicesInUse(Bundle bundle) {
        List<ServiceReference> registeredSR = ArrayKit.asList(bundle.getServicesInUse());
        return this.getServiceRefs(registeredSR);
    }

    private List<ServiceRef> getServiceRefs(List<ServiceReference> registeredSRs) {
        ArrayList serviceRefs = Lists.newArrayList();
        for (ServiceReference serviceReference : registeredSRs) {
            List<Bundle> usingBundles = ArrayKit.asList(serviceReference.getUsingBundles());
            TreeMap properties = Maps.newTreeMap(BY_STRING_VALUE_OF);
            for (String name : serviceReference.getPropertyKeys()) {
                Object value = serviceReference.getProperty(name);
                properties.put(name, this.prettyServiceValue(value));
            }
            String serviceId = (String)Option.option((Object)serviceReference.getProperty("service.id")).map(TO_STRING_OR_NULL).getOrElse((Object)"???");
            serviceRefs.add(new ServiceRef(serviceId, serviceReference.getBundle(), properties, usingBundles, this.makeObjectClasses(serviceReference)));
        }
        return serviceRefs;
    }

    private List<String> makeObjectClasses(ServiceReference serviceReference) {
        Object objectClass = serviceReference.getProperty("objectClass");
        ArrayList objectClasses = Lists.newArrayList();
        if (objectClass != null) {
            if (objectClass instanceof String[]) {
                Collections.addAll(objectClasses, (String[])objectClass);
            } else {
                objectClasses.add(String.valueOf(objectClass));
            }
        }
        return objectClasses;
    }

    private String prettyServiceValue(Object value) {
        if (value instanceof String[]) {
            return Joiner.on((char)',').join((Object[])((String[])value));
        }
        return String.valueOf(value);
    }

    private void inspectSpringContext(BeanCallback beanCallback, BundleContext bundleContext, ServiceReference sr) {
        Option springContext = Option.option((Object)((ApplicationContext)bundleContext.getService(sr)));
        if (springContext.isDefined()) {
            ApplicationContext applicationContext = (ApplicationContext)springContext.get();
            beanCallback.onSpringContext(applicationContext);
            List<String> beanDefinitionNames = ArrayKit.asList(applicationContext.getBeanDefinitionNames());
            for (String beanName : beanDefinitionNames) {
                Either<RuntimeException, Object> beanEither = this.getBean(applicationContext, beanName);
                BeanInspectionDefinitionImpl bDef = beanEither.isRight() ? new BeanInspectionDefinitionImpl(beanName, applicationContext.isSingleton(beanName), applicationContext.isPrototype(beanName), beanEither) : new BeanInspectionDefinitionImpl(beanName, false, false, beanEither);
                beanCallback.onSpringBean(bDef);
            }
        }
    }

    private List<ServiceReference> getSpringContext(final long bundleId) {
        try {
            List<ServiceReference> fromList = ArrayKit.asList(this.bundleContext.getAllServiceReferences(ApplicationContext.class.getName(), null));
            return Lists.newArrayList((Iterable)Iterables.filter(fromList, (Predicate)new Predicate<ServiceReference>(){

                public boolean apply(ServiceReference input) {
                    return input.getBundle().getBundleId() == bundleId;
                }
            }));
        }
        catch (InvalidSyntaxException e) {
            return Collections.emptyList();
        }
    }

    private Either<RuntimeException, Object> getBean(ApplicationContext springContext, String beanName) {
        try {
            return Either.right((Object)springContext.getBean(beanName));
        }
        catch (RuntimeException e) {
            return Either.left((Object)e);
        }
    }

    public PluginBundle newPluginBundle(Bundle bundle) {
        String pluginKey = BundleInspector.getPluginKey(bundle);
        return new PluginBundle(pluginKey, bundle, this.isAtlassianPlugin(pluginKey));
    }

    public Option<PluginBundle> newPluginBundle(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin == null) {
            return Option.none();
        }
        Option<Bundle> bundle = this.findBundle(plugin);
        return bundle.map(this.toPluginBundle());
    }

    private Function<Bundle, PluginBundle> toPluginBundle() {
        return new Function<Bundle, PluginBundle>(){

            public PluginBundle apply(Bundle from) {
                return BundleInspector.this.newPluginBundle(from);
            }
        };
    }

    private Option<Bundle> findBundle(Plugin plugin) {
        String pluginKey = plugin.getKey();
        List<Bundle> bundles = ArrayKit.asList(this.bundleContext.getBundles());
        for (Bundle bundle : bundles) {
            if (!pluginKey.equals(BundleInspector.getPluginKey(bundle))) continue;
            return Option.some((Object)bundle);
        }
        return Option.none();
    }

    private boolean isAtlassianPlugin(String pluginKey) {
        return this.pluginAccessor.getPlugin(pluginKey) != null;
    }

    public String guessBeanClass(Object bean) {
        String className = bean.getClass().getName();
        if (className.startsWith("com.sun.proxy")) {
            try {
                Object h = Reflect.on((Object)bean).get("h");
                Object advised = Reflect.on((Object)h).get("advised");
                List interfaces = (List)Reflect.on((Object)advised).get("interfaces");
                if (interfaces != null && interfaces.size() > 0 && interfaces.get(0) != null) {
                    return ((Class)interfaces.get(0)).getName();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return className;
    }

    public static String getPluginKey(Bundle bundle) {
        Option pluginKey = Option.option(bundle.getHeaders().get(ATLASSIAN_PLUGIN_KEY)).map(TO_STRING_OR_NULL);
        if (pluginKey.isEmpty()) {
            pluginKey = Option.option((Object)bundle.getSymbolicName());
        }
        return (String)pluginKey.getOrElse((Object)("Unknown?? : " + bundle.getBundleId()));
    }

    private static class BeanInspectionDefinitionImpl
    implements BeanInspectionDefinition {
        private final String beanName;
        private final boolean singleton;
        private final boolean prototype;
        private final Either<RuntimeException, Object> beanEither;

        public BeanInspectionDefinitionImpl(String beanName, boolean singleton, boolean prototype, Either<RuntimeException, Object> beanEither) {
            this.beanName = beanName;
            this.singleton = singleton;
            this.prototype = prototype;
            this.beanEither = beanEither;
        }

        @Override
        public String beanName() {
            return this.beanName;
        }

        @Override
        public boolean singleton() {
            return this.singleton;
        }

        @Override
        public boolean prototype() {
            return this.prototype;
        }

        @Override
        public Option<RuntimeException> beanException() {
            return Option.option((Object)this.beanEither.left().getOrNull());
        }

        @Override
        public Option<Object> bean() {
            return Option.option((Object)this.beanEither.right().getOrNull());
        }
    }

    public static class ServiceRef {
        public final String serviceId;
        public final Bundle offeringBundle;
        public final Map<String, String> serviceProperties;
        public final List<Bundle> usingBundles;
        public final List<String> objectClasses;

        public ServiceRef(String serviceId, Bundle offeringBundle, Map<String, String> serviceProperties, List<Bundle> usingBundles, List<String> objectClasses) {
            this.serviceId = serviceId;
            this.offeringBundle = offeringBundle;
            this.objectClasses = objectClasses;
            this.serviceProperties = Maps.newHashMap(serviceProperties);
            this.usingBundles = ImmutableList.copyOf(usingBundles);
        }
    }

    public static interface PluginCallback {
        public void onModuleDescriptor(ModuleDescriptor<?> var1, boolean var2);
    }

    public static interface BundleServiceCallback {
        public void onBundle(PluginBundle var1, ServiceRef var2);
    }

    public static interface BundleCallback {
        public void onBundle(PluginBundle var1);
    }

    public static interface BeanCallback {
        public void onStart(PluginBundle var1);

        public void onSpringContext(ApplicationContext var1);

        public void onSpringBean(BeanInspectionDefinition var1);
    }

    public static interface BeanInspectionDefinition {
        public String beanName();

        public boolean singleton();

        public boolean prototype();

        public Option<Object> bean();

        public Option<RuntimeException> beanException();
    }
}

