/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.fugue.Pair;
import com.atlassian.labs.plugins.quickreload.rest.ResourceLink;
import com.atlassian.labs.plugins.quickreload.utils.HttpKit;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class Links {

    public static class ApiLinks {
        public final ResourceLink self;
        public final ResourceLink api;
        public final ResourceLink bundles;
        public final ResourceLink plugins;
        public final ResourceLink services;
        public final ResourceLink events;
        public final ResourceLink controlPanel;
        public final ResourceLink state;
        public final ResourceLink stateEnable;
        public final ResourceLink stateDisable;
        public final ResourceLink pluginInstall;
        public final ResourceLink pluginUninstall;
        public final ResourceLink pluginState;
        public final ResourceLink pluginEnable;
        public final ResourceLink pluginDisable;
        public final ResourceLink tracked;
        public final ResourceLink track;
        public final ResourceLink untrack;
        public final ResourceLink batching;
        public final ResourceLink batchingEnable;
        public final ResourceLink batchingDisable;
        public final ResourceLink batchingSetState;

        static Builder builder(UriInfo uriInfo) {
            return new Builder(uriInfo);
        }

        private ApiLinks(UriInfo uriInfo) {
            this.self = ResourceLink.get(uriInfo.getAbsolutePath().toASCIIString());
            this.api = ResourceLink.get(uriInfo.getBaseUriBuilder().path("api"), new Pair[0]);
            UriBuilder stateURL = uriInfo.getBaseUriBuilder().path("state");
            this.state = ResourceLink.get(stateURL, new Pair[0]);
            this.stateEnable = ResourceLink.put(stateURL, new Pair[0]);
            this.stateDisable = ResourceLink.delete(stateURL, new Pair[0]);
            this.pluginInstall = ResourceLink.post(uriInfo.getBaseUriBuilder().path("plugin/install/{fullJarPath}"), new Pair[0]);
            this.pluginUninstall = ResourceLink.delete(uriInfo.getBaseUriBuilder().path("plugin/install/{pluginKey}"), new Pair[0]);
            this.pluginState = ResourceLink.get(uriInfo.getBaseUriBuilder().path("plugin/enabled/{pluginOrModuleKey}"), new Pair[0]);
            this.pluginEnable = ResourceLink.post(uriInfo.getBaseUriBuilder().path("plugin/enabled/{pluginOrModuleKey}"), new Pair[0]);
            this.pluginDisable = ResourceLink.delete(uriInfo.getBaseUriBuilder().path("plugin/enabled/{pluginOrModuleKey}"), new Pair[0]);
            this.tracked = ResourceLink.get(uriInfo.getBaseUriBuilder().path("tracked"), new Pair[0]);
            this.track = ResourceLink.post(uriInfo.getBaseUriBuilder().path("tracked/{fullDirectoryPath}"), new Pair[0]);
            this.untrack = ResourceLink.delete(uriInfo.getBaseUriBuilder().path("tracked/{fullDirectoryPath}"), new Pair[0]);
            UriBuilder batchingURL = uriInfo.getBaseUriBuilder().path("batching");
            this.batching = ResourceLink.get(batchingURL, new Pair[0]);
            this.batchingEnable = ResourceLink.put(batchingURL, new Pair[0]);
            this.batchingDisable = ResourceLink.delete(batchingURL, new Pair[0]);
            UriBuilder batchingUpdateWithGetURL = uriInfo.getBaseUriBuilder().path("batching").path("setState");
            this.batchingSetState = ResourceLink.get(batchingUpdateWithGetURL, Pair.pair((Object)"?enabled", (Object)"{true|false}"));
            this.bundles = ResourceLink.get(uriInfo.getBaseUriBuilder().path("bundles"), new Pair[0]);
            this.plugins = ResourceLink.get(uriInfo.getBaseUriBuilder().path("plugins"), new Pair[0]);
            this.services = ResourceLink.get(uriInfo.getBaseUriBuilder().path("services"), new Pair[0]);
            this.events = ResourceLink.get(uriInfo.getBaseUriBuilder().path("events"), new Pair[0]);
            this.controlPanel = ResourceLink.get(uriInfo.getBaseUriBuilder().replacePath(HttpKit.chopContextPathFromRestUrl(uriInfo)).path("/plugins/servlet/qr"), new Pair[0]);
        }

        static class Builder
        extends BasicLinkBuilder {
            private Builder(UriInfo uriInfo) {
                super(uriInfo);
            }

            ApiLinks build() {
                return new ApiLinks(this.uriInfo);
            }
        }
    }

    static class ModuleLinks {
        public final ResourceLink enabledState;
        public final ResourceLink enable;
        public final ResourceLink disable;
        public final ResourceLink pluginInfo;

        static Builder builder(UriInfo uriInfo) {
            return new Builder(uriInfo);
        }

        private ModuleLinks(String url, String pluginInfoUrl) {
            this.enabledState = ResourceLink.get(url);
            this.enable = ResourceLink.post(url);
            this.disable = ResourceLink.delete(url);
            this.pluginInfo = ResourceLink.get(pluginInfoUrl);
        }

        static class Builder
        extends BasicLinkBuilder {
            private String pluginKey;
            private String moduleKey;

            private Builder(UriInfo uriInfo) {
                super(uriInfo);
            }

            Builder withPluginKey(String pluginKey) {
                this.pluginKey = pluginKey;
                return this;
            }

            Builder withModuleKey(String moduleKey) {
                this.moduleKey = moduleKey;
                return this;
            }

            ModuleLinks build() {
                return new ModuleLinks(this.uriInfo.getBaseUriBuilder().path("plugin/enabled").path("{moduleKey}").build(new Object[]{this.moduleKey}).toASCIIString(), this.uriInfo.getBaseUriBuilder().path("plugins").path("{pluginKey}").build(new Object[]{this.pluginKey}).toASCIIString());
            }
        }
    }

    static class PluginLinks {
        public final ResourceLink enabledState;
        public final ResourceLink enable;
        public final ResourceLink disable;
        public final ResourceLink pluginInfo;

        static Builder builder(UriInfo uriInfo) {
            return new Builder(uriInfo);
        }

        private PluginLinks(String infoUrl, String enableUrl) {
            this.pluginInfo = ResourceLink.get(infoUrl);
            this.enabledState = ResourceLink.get(enableUrl);
            this.enable = ResourceLink.post(enableUrl);
            this.disable = ResourceLink.delete(enableUrl);
        }

        static class Builder
        extends BasicLinkBuilder {
            private String pluginKey;

            private Builder(UriInfo uriInfo) {
                super(uriInfo);
            }

            Builder withPluginKey(String pluginKey) {
                this.pluginKey = pluginKey;
                return this;
            }

            PluginLinks build() {
                return new PluginLinks(this.uriInfo.getBaseUriBuilder().path("plugins").path("{pluginKey}").build(new Object[]{this.pluginKey}).toASCIIString(), this.uriInfo.getBaseUriBuilder().path("plugin/enabled").path("{pluginKey}").build(new Object[]{this.pluginKey}).toASCIIString());
            }
        }
    }

    static class BundleLinks {
        public final String name;
        public final ResourceLink self;
        public final ResourceLink upmRepresentation;
        public final ResourceLink enabledState;
        public final ResourceLink enable;
        public final ResourceLink disable;

        static Builder builder(UriInfo uriInfo) {
            return new Builder(uriInfo);
        }

        private BundleLinks(String name, String self, String upmRepresentation, String enabledState) {
            this.name = name;
            this.self = ResourceLink.get(self);
            this.upmRepresentation = ResourceLink.get(upmRepresentation);
            this.enabledState = ResourceLink.get(enabledState);
            this.enable = ResourceLink.post(enabledState);
            this.disable = ResourceLink.delete(enabledState);
        }

        static class Builder
        extends BasicLinkBuilder {
            private long bundleId;
            private String pluginKey;
            private String name;

            private Builder(UriInfo uriInfo) {
                super(uriInfo);
            }

            Builder withName(String name) {
                this.name = name;
                return this;
            }

            Builder withBundleId(long bundleId) {
                this.bundleId = bundleId;
                return this;
            }

            Builder withPluginKey(String pluginKey) {
                this.pluginKey = pluginKey;
                return this;
            }

            BundleLinks build() {
                String context = HttpKit.chopContextPathFromRestUrl(this.uriInfo);
                return new BundleLinks(this.name, this.uriInfo.getBaseUriBuilder().path("bundles").path("{bundleId}").build(new Object[]{this.bundleId}).toASCIIString(), this.uriInfo.getBaseUriBuilder().replacePath(context).path("/rest/plugins/1.0/bundles/{bundleId}").build(new Object[]{this.bundleId}).toASCIIString(), this.uriInfo.getBaseUriBuilder().path("plugin/enabled").path("{pluginKey}").build(new Object[]{this.pluginKey}).toASCIIString());
            }
        }
    }

    private static class BasicLinkBuilder {
        protected final UriInfo uriInfo;

        private BasicLinkBuilder(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
        }
    }
}

