/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.labs.plugins.quickreload.inspectors.BundleHeaderParser;
import com.atlassian.labs.plugins.quickreload.inspectors.BundleInspector;
import com.atlassian.labs.plugins.quickreload.inspectors.PluginBundle;
import com.atlassian.labs.plugins.quickreload.rest.Links;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.format.ISODateTimeFormat;
import org.osgi.framework.Bundle;
import org.springframework.context.ApplicationContext;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json", "text/plain", "application/x-www-form-urlencoded"})
@Path(value="/")
public class BundlesResource {
    private final BundleInspector bundleInspector;
    private static final Map<Integer, String> STATES = Maps.newHashMap();

    @Inject
    public BundlesResource(BundleInspector bundleInspector) {
        this.bundleInspector = bundleInspector;
    }

    @GET
    @Path(value="/services")
    @AnonymousAllowed
    public Response getBundleServices(@Context UriInfo uriInfo) throws IOException {
        return Response.ok((Object)this.bundleServices(uriInfo), (String)"application/json").build();
    }

    @GET
    @Path(value="/bundles")
    @AnonymousAllowed
    public Response getAllBundles(@Context UriInfo uriInfo) throws IOException {
        return Response.ok((Object)this.bundles(uriInfo, (Predicate<PluginBundle>)Predicates.alwaysTrue()), (String)"application/json").build();
    }

    @GET
    @Path(value="/plugins")
    @AnonymousAllowed
    public Response getAllPlugins(@Context UriInfo uriInfo) throws IOException {
        return Response.ok((Object)this.bundles(uriInfo, this.pluginsOnly()), (String)"application/json").build();
    }

    @GET
    @Path(value="/plugins/{pluginKey}")
    @AnonymousAllowed
    public Response getPlugin(@Context UriInfo uriInfo, @PathParam(value="pluginKey") String pluginKey) throws IOException {
        Option<SingleBundle> bundle = this.singlePlugin(uriInfo, pluginKey);
        if (bundle.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/html").build();
        }
        return Response.ok((Object)bundle.get(), (String)"application/json").build();
    }

    @GET
    @Path(value="/bundles/{bundleId : \\d+}")
    @AnonymousAllowed
    public Response getBundle(@Context UriInfo uriInfo, @PathParam(value="bundleId") long bundleId) throws IOException {
        Option<SingleBundle> bundle = this.singleBundle(uriInfo, bundleId);
        if (bundle.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/html").build();
        }
        return Response.ok((Object)bundle.get(), (String)"application/json").build();
    }

    private Predicate<PluginBundle> pluginsOnly() {
        return new Predicate<PluginBundle>(){

            public boolean apply(PluginBundle input) {
                return input.isAtlassianPlugin();
            }
        };
    }

    private AllBundles bundles(final UriInfo uriInfo, final Predicate<PluginBundle> predicate) {
        final ArrayList bundles = Lists.newArrayList();
        this.bundleInspector.inspectBundles(new BundleInspector.BundleCallback(){

            @Override
            public void onBundle(PluginBundle pluginBundle) {
                if (predicate.apply((Object)pluginBundle)) {
                    Links.BundleLinks links = BundlesResource.createBundleLinks(uriInfo, pluginBundle.getBundle());
                    BundleInfo bundleInfo = new BundleInfo(links, pluginBundle.getPluginKey(), pluginBundle.getBundle());
                    bundles.add(bundleInfo);
                }
            }
        });
        return new AllBundles(uriInfo, bundles);
    }

    private Option<SingleBundle> singlePlugin(UriInfo uriInfo, String pluginKey) {
        Option<PluginBundle> pluginBundle = this.bundleInspector.newPluginBundle(pluginKey);
        if (pluginBundle.isDefined()) {
            return this.singleBundle(uriInfo, ((PluginBundle)pluginBundle.get()).getBundle().getBundleId());
        }
        return Option.none();
    }

    private Option<SingleBundle> singleBundle(final UriInfo uriInfo, long bundleId) {
        final ArrayList beans = Lists.newArrayList();
        final AtomicReference pluginBundleRef = new AtomicReference();
        final AtomicReference springContextRef = new AtomicReference();
        this.bundleInspector.inspectBundle(bundleId, new BundleInspector.BeanCallback(){

            @Override
            public void onStart(PluginBundle pluginBundle) {
                pluginBundleRef.set(pluginBundle);
            }

            @Override
            public void onSpringContext(ApplicationContext applicationContext) {
                springContextRef.set(applicationContext);
            }

            @Override
            public void onSpringBean(BundleInspector.BeanInspectionDefinition def) {
                Option beanClassGuess = def.bean().map(BundlesResource.this.toClassNameGuess());
                Option beanException = def.beanException().map(BundlesResource.this.toException());
                Pair beanToString = BundlesResource.this.beanToString(def.bean().getOrNull());
                BeanInfo bean = new BeanInfo(def.beanName(), (String)beanToString.left(), (String)beanToString.right(), (String)beanClassGuess.getOrNull(), (String)beanException.getOrNull(), def.singleton(), def.prototype());
                beans.add(bean);
            }
        });
        PluginBundle pluginBundle = (PluginBundle)pluginBundleRef.get();
        if (pluginBundle == null) {
            return Option.none();
        }
        Bundle bundle = pluginBundle.getBundle();
        Services offeredServices = this.buildOfferedServices(uriInfo, bundle);
        Services consumedServices = this.buildConsumedServices(uriInfo, bundle);
        FullBundleInfo bundleInfo = new FullBundleInfo(uriInfo, pluginBundle.getPluginKey(), bundle, offeredServices, consumedServices);
        SpringInfo springInfo = null;
        Option applicationContext = Option.option(springContextRef.get());
        if (applicationContext.isDefined()) {
            springInfo = new SpringInfo((ApplicationContext)applicationContext.get(), beans);
        }
        final ArrayList modules = Lists.newArrayList();
        Option<Plugin> plugin = this.bundleInspector.inspectBundlePluginModules(bundleId, new BundleInspector.PluginCallback(){

            @Override
            public void onModuleDescriptor(ModuleDescriptor<?> moduleDescriptor, boolean enabled) {
                modules.add(BundlesResource.this.toModuleInfo(uriInfo, moduleDescriptor));
            }
        });
        PluginInfo pluginInfo = null;
        if (plugin.isDefined()) {
            pluginInfo = this.toPluginInfo(uriInfo, (Plugin)plugin.get(), modules);
        }
        return Option.some((Object)new SingleBundle(uriInfo, BundlesResource.buildBundleDescriptiveName(bundle), bundleInfo, springInfo, pluginInfo));
    }

    private Pair<String, String> beanToString(Object bean) {
        try {
            return Pair.pair((Object)String.valueOf(bean), (Object)(bean == null ? "null" : bean.getClass().getName()));
        }
        catch (Exception e) {
            return Pair.pair((Object)e.toString(), (Object)e.getClass().getName());
        }
    }

    private AllServices bundleServices(final UriInfo uriInfo) {
        final ArrayList services = Lists.newArrayList();
        this.bundleInspector.inspectBundleServices(new BundleInspector.BundleServiceCallback(){

            @Override
            public void onBundle(PluginBundle pluginBundle, BundleInspector.ServiceRef service) {
                services.add(BundlesResource.this.toJsonService(uriInfo).apply((Object)service));
            }
        });
        return new AllServices(uriInfo, services);
    }

    private PluginInfo toPluginInfo(UriInfo uriInfo, Plugin p2, List<ModuleInfo> modules) {
        PluginInformation information = p2.getPluginInformation();
        PluginInfo pluginInfo = new PluginInfo(p2.getKey(), p2.getName(), information.getDescription(), information.getVersion(), information.getVendorName(), this.bundleInspector.isEnabled(p2), this.bundleInspector.isSystemPlugin(p2), this.createPluginLinks(p2, uriInfo), modules);
        return pluginInfo;
    }

    private ModuleInfo toModuleInfo(UriInfo uriInfo, ModuleDescriptor<?> moduleDescriptor) {
        return new ModuleInfo(moduleDescriptor.getCompleteKey(), moduleDescriptor.getName(), moduleDescriptor.getDescription(), moduleDescriptor.getClass().getName(), String.valueOf(moduleDescriptor.getModuleClass()), true, this.createModuleLinks(moduleDescriptor, uriInfo));
    }

    private Links.ModuleLinks createModuleLinks(ModuleDescriptor<?> moduleDescriptor, UriInfo uriInfo) {
        return Links.ModuleLinks.builder(uriInfo).withModuleKey(moduleDescriptor.getCompleteKey()).withPluginKey(moduleDescriptor.getPluginKey()).build();
    }

    private Links.PluginLinks createPluginLinks(Plugin p2, UriInfo uriInfo) {
        return Links.PluginLinks.builder(uriInfo).withPluginKey(p2.getKey()).build();
    }

    private static String buildBundleDescriptiveName(Bundle bundle) {
        return String.format("%s - %s (%d)", bundle.getHeaders().get("Bundle-Name"), bundle.getSymbolicName(), bundle.getBundleId());
    }

    private static String buildBundleName(Bundle bundle) {
        Object name = bundle.getHeaders().get("Bundle-Name");
        return Objects.toString(name, bundle.getSymbolicName());
    }

    private Services buildOfferedServices(UriInfo uriInfo, Bundle bundle) {
        List<BundleInspector.ServiceRef> serviceRefs = this.bundleInspector.inspectRegisteredServices(bundle);
        Collection services = Collections2.transform(serviceRefs, this.toJsonService(uriInfo));
        return new Services(services);
    }

    private Services buildConsumedServices(UriInfo uriInfo, Bundle bundle) {
        List<BundleInspector.ServiceRef> serviceRefs = this.bundleInspector.inspectServicesInUse(bundle);
        Collection services = Collections2.transform(serviceRefs, this.toJsonService(uriInfo));
        return new Services(services);
    }

    private Function<BundleInspector.ServiceRef, ServiceInfo> toJsonService(final UriInfo uriInfo) {
        return new Function<BundleInspector.ServiceRef, ServiceInfo>(){

            public ServiceInfo apply(BundleInspector.ServiceRef from) {
                Links.BundleLinks offeringBundle = (Links.BundleLinks)BundlesResource.this.toBundleLinks(uriInfo).apply((Object)from.offeringBundle);
                Collection usingLinks = Collections2.transform(from.usingBundles, (Function)BundlesResource.this.toBundleLinks(uriInfo));
                return new ServiceInfo(from.serviceId, from.objectClasses, offeringBundle, from.serviceProperties, usingLinks);
            }
        };
    }

    private Function<Bundle, Links.BundleLinks> toBundleLinks(final UriInfo uriInfo) {
        return new Function<Bundle, Links.BundleLinks>(){

            public Links.BundleLinks apply(Bundle from) {
                return BundlesResource.createBundleLinks(uriInfo, from);
            }
        };
    }

    private Function<Exception, String> toException() {
        return new Function<Exception, String>(){

            public String apply(Exception from) {
                return BundlesResource.this.makeExceptionStr(from);
            }
        };
    }

    private Function<Object, String> toClassNameGuess() {
        return new Function<Object, String>(){

            public String apply(Object from) {
                return BundlesResource.this.bundleInspector.guessBeanClass(from);
            }
        };
    }

    private String makeExceptionStr(Exception from) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        from.printStackTrace(pw);
        return sw.toString();
    }

    static Links.BundleLinks createBundleLinks(UriInfo uriInfo, Bundle bundle) {
        return Links.BundleLinks.builder(uriInfo).withName(BundlesResource.buildBundleDescriptiveName(bundle)).withBundleId(bundle.getBundleId()).withPluginKey(BundleInspector.getPluginKey(bundle)).build();
    }

    static {
        STATES.put(32, "ACTIVE");
        STATES.put(2, "INSTALLED");
        STATES.put(4, "RESOLVED");
        STATES.put(8, "STARTING");
        STATES.put(16, "STOPPING");
        STATES.put(1, "UNINSTALLED");
    }

    static class BeanInfo {
        public final String beanName;
        public final String bean;
        public final String beanClass;
        public final String beanClassGuess;
        public final String beanException;
        public final boolean singleton;
        public final boolean prototype;

        BeanInfo(String beanName, String bean, String beanClass, String beanClassGuess, String beanException, boolean singleton, boolean prototype) {
            this.beanName = beanName;
            this.bean = bean == null ? null : String.valueOf(bean);
            this.beanClass = beanClass;
            this.beanClassGuess = beanClassGuess;
            this.beanException = beanException;
            this.singleton = singleton;
            this.prototype = prototype;
        }
    }

    static class SpringInfo {
        public final String id;
        public final String displayName;
        public final String startDate;
        public final int beanCount;
        public final Collection<BeanInfo> beans;

        SpringInfo(ApplicationContext applicationContext, Collection<BeanInfo> beans) {
            this.id = applicationContext.getId();
            this.displayName = applicationContext.getDisplayName();
            this.startDate = ISODateTimeFormat.dateTime().print(applicationContext.getStartupDate());
            this.beanCount = beans.size();
            this.beans = beans;
        }
    }

    static class ModuleInfo {
        public final String completeKey;
        public final String name;
        public final String description;
        public final String moduleDescriptorClass;
        public final String moduleClass;
        public final boolean enabled;
        public final Links.ModuleLinks moduleLinks;

        ModuleInfo(String completeKey, String name, String description, String moduleDescriptorClass, String moduleClass, boolean enabled, Links.ModuleLinks moduleLinks) {
            this.completeKey = completeKey;
            this.name = name;
            this.description = description;
            this.moduleDescriptorClass = moduleDescriptorClass;
            this.moduleClass = moduleClass;
            this.enabled = enabled;
            this.moduleLinks = moduleLinks;
        }
    }

    static class PluginInfo {
        public final String pluginKey;
        public final String name;
        public final String description;
        public final String version;
        public final boolean enabled;
        public final String vendor;
        public final boolean systemPlugin;
        public final Links.PluginLinks links;
        public final Collection<ModuleInfo> modules;

        PluginInfo(String pluginKey, String name, String description, String version, String vendor, boolean enabled, boolean systemPlugin, Links.PluginLinks links, Collection<ModuleInfo> modules) {
            this.pluginKey = pluginKey;
            this.name = name;
            this.description = description;
            this.version = version;
            this.vendor = vendor;
            this.enabled = enabled;
            this.systemPlugin = systemPlugin;
            this.links = links;
            this.modules = modules;
        }
    }

    static class FullBundleInfo
    extends BundleInfo {
        public final Collection<BundleHeaderParser.ParsedHeader> parsedHeaders;
        public final Map<String, String> simpleHeaders;
        public final Services offeredServices;
        public final Services consumedServices;

        FullBundleInfo(UriInfo uriInfo, String pluginKey, Bundle bundle, Services offeredServices, Services consumedServices) {
            super(BundlesResource.createBundleLinks(uriInfo, bundle), pluginKey, bundle);
            this.parsedHeaders = BundleHeaderParser.getParseableHeaders(bundle);
            this.simpleHeaders = BundleHeaderParser.getSimpleHeaders(bundle);
            this.offeredServices = offeredServices;
            this.consumedServices = consumedServices;
        }
    }

    static class Services {
        public final Collection<ServiceInfo> services;

        Services(Collection<ServiceInfo> services) {
            this.services = services;
        }
    }

    static class ServiceInfo {
        public final String serviceId;
        public final Collection<String> objectClasses;
        public final Map<String, String> serviceProperties;
        public final Links.BundleLinks offeringBundle;
        public final Collection<Links.BundleLinks> usingBundles;

        ServiceInfo(String serviceId, Collection<String> objectClasses, Links.BundleLinks offeringBundle, Map<String, String> serviceProperties, Collection<Links.BundleLinks> usingBundles) {
            this.serviceId = serviceId;
            this.objectClasses = objectClasses;
            this.offeringBundle = offeringBundle;
            this.serviceProperties = serviceProperties;
            this.usingBundles = usingBundles;
        }
    }

    static class BundleInfo {
        public final long bundleId;
        public final String name;
        public final String version;
        public final String state;
        public final String bundleSymbolicName;
        public final String pluginKey;
        public final String location;
        public final Links.BundleLinks links;

        BundleInfo(Links.BundleLinks links, String pluginKey, Bundle bundle) {
            this.links = links;
            this.pluginKey = pluginKey;
            this.name = BundlesResource.buildBundleName(bundle);
            this.bundleSymbolicName = bundle.getSymbolicName();
            this.bundleId = bundle.getBundleId();
            this.location = bundle.getLocation();
            this.version = bundle.getVersion().toString();
            this.state = (String)STATES.get(bundle.getState());
        }
    }

    static class SingleBundle {
        public final String name;
        public final SpringInfo springInfo;
        public final PluginInfo pluginInfo;
        public final BundleInfo bundleInfo;
        public final Links.ApiLinks api;

        SingleBundle(UriInfo uriInfo, String name, BundleInfo bundleInfo, SpringInfo springInfo, PluginInfo pluginInfo) {
            this.name = name;
            this.pluginInfo = pluginInfo;
            this.api = Links.ApiLinks.builder(uriInfo).build();
            this.bundleInfo = bundleInfo;
            this.springInfo = springInfo;
        }
    }

    static class AllBundles {
        public final Collection<BundleInfo> bundles;
        public final Links.ApiLinks api;

        AllBundles(UriInfo uriInfo, Collection<BundleInfo> bundles) {
            this.api = Links.ApiLinks.builder(uriInfo).build();
            this.bundles = bundles;
        }
    }

    static class AllServices {
        public final Collection<ServiceInfo> serviceInfo;
        public final Links.ApiLinks api;

        AllServices(UriInfo uriInfo, Collection<ServiceInfo> services) {
            this.api = Links.ApiLinks.builder(uriInfo).build();
            this.serviceInfo = services;
        }
    }
}

