/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.config;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.labs.plugins.quickreload.utils.Files;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PomConventionStrategy {
    private final File startDir;

    public PomConventionStrategy(File startDir) {
        this.startDir = startDir;
    }

    public List<File> getTargetDirs() {
        Option<File> lastPomFile = Files.traverseUpForFileThenYouFindItAndTheCant("pom.xml", this.startDir);
        if (lastPomFile.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList trackedDirs = Lists.newArrayList();
        File startDir = ((File)lastPomFile.get()).getParentFile();
        Files.traverseDownLookingForFile("pom.xml", startDir, new Effect<File>(){

            public void apply(File file) {
                if (!Files.pathContainsDirectory(file, "target")) {
                    PomConventionStrategy.this.addTargetToList(trackedDirs, file);
                }
            }
        });
        return trackedDirs;
    }

    private void addTargetToList(List<File> trackedDirs, File file) {
        File target = Files.smooshNames(file.getParent(), "target");
        try {
            trackedDirs.add(target.getCanonicalFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

