/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.fugue.Effect;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.labs.plugins.quickreload.config.BasicConfigFileReader;
import com.atlassian.labs.plugins.quickreload.utils.Files;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.inject.Named;

@Named
public class WittyQuoter
implements LifecycledComponent {
    private static Random r = new Random();
    private static List<String> STATIC_WIT = Lists.newArrayList((Object[])new String[]{"A watched plugin never boils!", "Stealing back time from Maven since 2013.", "Just press up arrow!", "Waiting for Bamboo / JAC / EAC / Godot ..."});
    private List<String> trueWit = STATIC_WIT;

    public String halfWit() {
        int index = r.nextInt(this.trueWit.size() - 1);
        return this.trueWit.get(index);
    }

    @Override
    public void onStartup() {
        final ArrayList wit = Lists.newArrayList(STATIC_WIT);
        Files.traverseUpLookingForFile(".halfwit", Files.pwd(), new Effect<File>(){

            public void apply(File file) {
                wit.addAll(WittyQuoter.this.readWit(file));
            }
        });
        this.trueWit = wit;
    }

    private List<String> readWit(File witFile) {
        try {
            return new BasicConfigFileReader().readConfigFileEntries(witFile);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    @Override
    public void onShutdown() {
    }
}

