/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.httpservice;

import com.atlassian.labs.httpservice.DefaultContextImpl;
import com.atlassian.labs.httpservice.ServletManager;
import com.atlassian.labs.httpservice.descriptors.HttpServiceServletFilterModuleDescriptor;
import com.atlassian.labs.httpservice.descriptors.LegacyHttpServiceServletFilterModuleDescriptor;
import com.atlassian.labs.httpservice.resource.ResourceFilter;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceImpl
implements HttpService {
    private final ServletManager servletManager;
    private final ResourceFilter resourceFilter;
    private final Bundle bundle;
    private static final Log log = LogFactory.getLog(HttpServiceImpl.class);
    private final ServiceRegistration filterReg;
    private ServletFilterModuleDescriptor filterDescriptor;

    public HttpServiceImpl(Plugin plugin, Bundle bundle, ServletModuleManager servletModuleManager) {
        this.bundle = bundle;
        this.servletManager = new ServletManager(plugin, bundle, servletModuleManager);
        this.resourceFilter = new ResourceFilter(this.servletManager);
        this.filterDescriptor = this.createServletDescriptor(plugin, servletModuleManager);
        this.filterDescriptor.enabled();
        this.filterReg = bundle.getBundleContext().registerService(ModuleDescriptor.class.getName(), (Object)this.filterDescriptor, null);
    }

    private ServletFilterModuleDescriptor createServletDescriptor(Plugin plugin, ServletModuleManager servletModuleManager) {
        try {
            this.getClass().getClassLoader().loadClass("com.atlassian.plugin.module.ModuleFactory");
            return new HttpServiceServletFilterModuleDescriptor(plugin, this.resourceFilter, "/*", new Hashtable(), servletModuleManager);
        }
        catch (ClassNotFoundException e) {
            return new LegacyHttpServiceServletFilterModuleDescriptor(plugin, (Filter)this.resourceFilter, "/*", new Hashtable(), servletModuleManager);
        }
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultContextImpl(this.bundle);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary params, HttpContext osgiHttpContext) throws ServletException, NamespaceException {
        log.debug((Object)("http register servlet :" + this.bundle + ", alias: " + alias));
        this.validateAlias(alias);
        this.servletManager.addServlet(alias, servlet, params);
    }

    public void registerResources(String alias, String name, HttpContext osgiHttpContext) throws NamespaceException {
        log.debug((Object)("** http register resource :" + this.bundle + ", alias: " + alias));
        this.validateAlias(alias);
        this.validateName(name);
        if (osgiHttpContext == null) {
            osgiHttpContext = this.createDefaultHttpContext();
        }
        this.resourceFilter.addResource(alias, name, osgiHttpContext);
    }

    public void unregister(String alias) {
        this.servletManager.removeServlet(alias);
        this.resourceFilter.destroy();
    }

    void unregisterAll() {
        this.servletManager.removeAll();
        this.resourceFilter.destroy();
        this.filterDescriptor.disabled();
        this.filterReg.unregister();
    }

    private void validateAlias(String alias) {
        if (alias == null || !alias.equals("/") && (!alias.startsWith("/") || alias.endsWith("/"))) {
            throw new IllegalArgumentException("Invalid alias: " + alias);
        }
    }

    private void validateName(String name) {
        if (name == null || name.endsWith("/")) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
    }
}

