/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket.drafts;

import com.netiq.websocket.Draft;
import com.netiq.websocket.Framedata;
import com.netiq.websocket.FramedataImpl1;
import com.netiq.websocket.HandshakeBuilder;
import com.netiq.websocket.Handshakedata;
import com.netiq.websocket.WebSocket;
import com.netiq.websocket.exceptions.InvalidHandshakeException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Draft_75
extends Draft {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte START_OF_FRAME = 0;
    public static final byte END_OF_FRAME = -1;
    private boolean readingState = false;
    private ByteBuffer currentFrame;

    @Override
    public Draft.HandshakeState acceptHandshakeAsClient(Handshakedata request, Handshakedata response) {
        return request.getFieldValue("WebSocket-Origin").equals(response.getFieldValue("Origin")) && this.basicAccept(response) ? Draft.HandshakeState.MATCHED : Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public Draft.HandshakeState acceptHandshakeAsServer(Handshakedata handshakedata) {
        if (handshakedata.hasFieldValue("Origin") && this.basicAccept(handshakedata)) {
            return Draft.HandshakeState.MATCHED;
        }
        return Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public ByteBuffer createBinaryFrame(Framedata framedata) {
        byte[] pay = framedata.getPayloadData();
        ByteBuffer b = ByteBuffer.allocate(pay.length + 2);
        b.put((byte)0);
        b.put(pay);
        b.put((byte)-1);
        b.flip();
        return b;
    }

    @Override
    public List<Framedata> createFrames(byte[] binary, boolean mask) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public List<Framedata> createFrames(String text, boolean mask) {
        FramedataImpl1 frame = new FramedataImpl1();
        frame.setPayload(WebSocket.utf8Bytes(text));
        frame.setFin(true);
        frame.setOptcode(Framedata.Opcode.TEXT);
        frame.setTransferemasked(mask);
        return Collections.singletonList(frame);
    }

    @Override
    public HandshakeBuilder postProcessHandshakeRequestAsClient(HandshakeBuilder request) throws InvalidHandshakeException {
        request.put("Upgrade", "WebSocket");
        request.put("Connection", "Upgrade");
        return request;
    }

    @Override
    public HandshakeBuilder postProcessHandshakeResponseAsServer(Handshakedata request, HandshakeBuilder response) throws InvalidHandshakeException {
        response.setHttpStatusMessage("Web Socket Protocol Handshake");
        response.put("Upgrade", "WebSocket");
        response.put("Connection", request.getFieldValue("Connection"));
        response.put("WebSocket-Origin", request.getFieldValue("Origin"));
        String location = "ws://" + request.getFieldValue("Host") + request.getResourceDescriptor();
        response.put("WebSocket-Location", location);
        return response;
    }

    @Override
    public List<Framedata> translateFrame(ByteBuffer buffer, int read) {
        LinkedList<Framedata> frames = new LinkedList<Framedata>();
        for (int i = 0; i < read; ++i) {
            byte newestByte = buffer.get(i);
            if (newestByte == 0 && !this.readingState) {
                this.currentFrame = null;
                this.readingState = true;
                continue;
            }
            if (newestByte == -1 && this.readingState) {
                this.readingState = false;
                Object textFrame = null;
                if (this.currentFrame == null) continue;
                FramedataImpl1 curframe = new FramedataImpl1();
                curframe.setPayload(this.currentFrame.array());
                curframe.setFin(true);
                curframe.setOptcode(Framedata.Opcode.TEXT);
                frames.add(curframe);
                continue;
            }
            ByteBuffer frame = ByteBuffer.allocate((this.currentFrame != null ? this.currentFrame.capacity() : 0) + 1);
            if (this.currentFrame != null) {
                this.currentFrame.rewind();
                frame.put(this.currentFrame);
            }
            frame.put(newestByte);
            this.currentFrame = frame;
        }
        if (this.readingState) {
            FramedataImpl1 curframe = new FramedataImpl1();
            curframe.setPayload(this.currentFrame.array());
            curframe.setFin(false);
            curframe.setOptcode(Framedata.Opcode.TEXT);
            frames.add(curframe);
        }
        return frames;
    }
}

