/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket;

import com.netiq.websocket.Draft;
import com.netiq.websocket.Framedata;
import com.netiq.websocket.FramedataImpl1;
import com.netiq.websocket.HandshakeBuilder;
import com.netiq.websocket.Handshakedata;
import com.netiq.websocket.WebSocketListener;
import com.netiq.websocket.drafts.Draft_10;
import com.netiq.websocket.drafts.Draft_17;
import com.netiq.websocket.drafts.Draft_75;
import com.netiq.websocket.drafts.Draft_76;
import com.netiq.websocket.exceptions.InvalidFrameException;
import com.netiq.websocket.exceptions.InvalidHandshakeException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebSocket {
    public static final int DEFAULT_PORT = 80;
    public static final String UTF8 = "UTF-8";
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte START_OF_FRAME = 0;
    public static final byte END_OF_FRAME = -1;
    public static final boolean DEBUG = false;
    protected final SocketChannel socketChannel;
    protected boolean handshakeComplete;
    protected WebSocketListener wsl;
    protected ByteBuffer socketBuffer;
    protected BlockingQueue<ByteBuffer> bufferQueue;
    protected Object bufferQueueMutex = new Object();
    protected boolean readingState = false;
    protected Draft draft = null;
    protected Role role;
    protected Framedata currentframe;
    protected Handshakedata handshakerequest = null;
    public List<Draft> known_drafts;
    protected final int maxpayloadsize;

    public WebSocket(SocketChannel socketChannel, BlockingQueue<ByteBuffer> bufferQueue, WebSocketListener listener, Draft draft, int maxpayloadsize) {
        this.socketChannel = socketChannel;
        this.bufferQueue = bufferQueue;
        this.handshakeComplete = false;
        this.socketBuffer = ByteBuffer.allocate(8192);
        this.wsl = listener;
        this.role = Role.CLIENT;
        this.draft = draft;
        this.maxpayloadsize = maxpayloadsize;
    }

    public WebSocket(SocketChannel socketChannel, BlockingQueue<ByteBuffer> bufferQueue, WebSocketListener listener, int maxpayloadsize) {
        this.socketChannel = socketChannel;
        this.bufferQueue = bufferQueue;
        this.handshakeComplete = false;
        this.socketBuffer = ByteBuffer.allocate(8192);
        this.wsl = listener;
        this.role = Role.SERVER;
        this.draft = null;
        this.maxpayloadsize = maxpayloadsize;
        if (this.known_drafts == null || this.known_drafts.isEmpty()) {
            this.known_drafts = new ArrayList<Draft>(1);
            this.known_drafts.add(new Draft_17());
            this.known_drafts.add(new Draft_10());
            this.known_drafts.add(new Draft_76());
            this.known_drafts.add(new Draft_75());
        }
    }

    public void handleRead() throws IOException, NoSuchAlgorithmException {
        block30: {
            int bytesRead = -1;
            this.socketBuffer.rewind();
            bytesRead = this.socketChannel.read(this.socketBuffer);
            if (bytesRead == -1) {
                this.close();
            } else if (bytesRead > this.maxpayloadsize) {
                this.wsl.onError(new RuntimeException("recived packet to big"));
                this.abort("recived packet to big");
            } else if (bytesRead > 0) {
                if (!this.handshakeComplete) {
                    if (Draft.isFlashEdgeCase(this.socketBuffer.array(), bytesRead)) {
                        this.channelWrite(ByteBuffer.wrap(WebSocket.utf8Bytes(this.wsl.getFlashPolicy(this))));
                        return;
                    }
                    try {
                        Draft.HandshakeState handshakestate = null;
                        if (this.role == Role.SERVER) {
                            if (this.draft == null) {
                                HandshakeBuilder handshake = Draft.translateHandshakeHttp(this.socketBuffer.array(), bytesRead);
                                for (Draft d : this.known_drafts) {
                                    handshakestate = d.acceptHandshakeAsServer(handshake);
                                    if (handshakestate == Draft.HandshakeState.MATCHED) {
                                        HandshakeBuilder response = this.wsl.onHandshakeRecievedAsServer(this, d, handshake);
                                        this.channelWrite(d.createHandshake(d.postProcessHandshakeResponseAsServer(handshake, response), this.role));
                                        this.draft = d;
                                        this.handshakeComplete = true;
                                        this.open();
                                        return;
                                    }
                                    if (handshakestate != Draft.HandshakeState.MATCHING) continue;
                                    if (this.draft != null) {
                                        throw new InvalidHandshakeException("multible drafts matching");
                                    }
                                    this.draft = d;
                                }
                                if (this.draft == null) {
                                    this.abort("no draft matches");
                                }
                                return;
                            }
                            Handshakedata handshake = this.draft.translateHandshake(this.socketBuffer.array(), bytesRead);
                            handshakestate = this.draft.acceptHandshakeAsServer(handshake);
                            if (handshakestate == Draft.HandshakeState.MATCHED) {
                                this.open();
                            } else if (handshakestate != Draft.HandshakeState.MATCHING) {
                                this.abort("the handshake did finaly not match");
                            }
                            return;
                        }
                        if (this.role != Role.CLIENT) break block30;
                        Handshakedata handshake = this.draft.translateHandshake(this.socketBuffer.array(), bytesRead);
                        handshakestate = this.draft.acceptHandshakeAsClient(this.handshakerequest, handshake);
                        if (handshakestate == Draft.HandshakeState.MATCHED) {
                            this.handshakeComplete = true;
                            this.open();
                            break block30;
                        }
                        if (handshakestate == Draft.HandshakeState.MATCHING) {
                            return;
                        }
                        this.abort("draft " + this.draft.getClass().getSimpleName() + " or server refuses handshake");
                    }
                    catch (InvalidHandshakeException e) {
                        this.abort("draft " + this.draft + " refuses handshake: " + e.getMessage());
                    }
                } else {
                    List<Framedata> frames = this.draft.translateFrame(this.socketBuffer, bytesRead);
                    for (Framedata f : frames) {
                        Framedata.Opcode curop = f.getOpcode();
                        if (curop == null) continue;
                        if (curop == Framedata.Opcode.CLOSING) {
                            this.sendFrame(new FramedataImpl1(Framedata.Opcode.CLOSING));
                            this.close();
                            continue;
                        }
                        if (curop == Framedata.Opcode.PING) {
                            this.sendFrame(new FramedataImpl1(Framedata.Opcode.PONG));
                            continue;
                        }
                        if (curop == Framedata.Opcode.PONG) {
                            this.wsl.onPong();
                            continue;
                        }
                        if (this.currentframe == null) {
                            if (f.isFin()) {
                                if (f.getOpcode() == Framedata.Opcode.TEXT) {
                                    this.wsl.onMessage(this, new String(f.getPayloadData(), UTF8));
                                    continue;
                                }
                                if (f.getOpcode() != Framedata.Opcode.BINARY) continue;
                                this.wsl.onMessage(this, f.getPayloadData());
                                continue;
                            }
                            this.currentframe = f;
                            continue;
                        }
                        if (f.getOpcode() != Framedata.Opcode.CONTINIOUS) continue;
                        try {
                            this.currentframe.append(f);
                        }
                        catch (InvalidFrameException e) {
                            this.wsl.onError(e);
                            this.abort("invalid frame: " + e.getMessage());
                        }
                        if (!f.isFin()) continue;
                        this.wsl.onMessage(this, new String(f.getPayloadData(), UTF8));
                        this.currentframe = null;
                    }
                }
            }
        }
    }

    public void abort() throws IOException {
        this.abort("");
    }

    public void abort(String problemmessage) throws IOException {
        this.close();
    }

    public void close() throws IOException {
        this.currentframe = null;
        this.handshakerequest = null;
        this.socketChannel.close();
        this.wsl.onClose(this);
    }

    public boolean send(String text) throws IOException {
        if (!this.handshakeComplete) {
            throw new NotYetConnectedException();
        }
        if (text == null) {
            throw new NullPointerException("Cannot send 'null' data to a WebSocket.");
        }
        boolean mask = this.role == Role.CLIENT;
        List<Framedata> frames = this.draft.createFrames(text, mask);
        if (frames.isEmpty()) {
            return true;
        }
        boolean sendall = true;
        for (Framedata f : frames) {
            sendall = this.sendFrame(f);
        }
        return sendall;
    }

    public boolean sendFrame(Framedata framedata) throws IOException {
        ByteBuffer b = this.draft.createBinaryFrame(framedata);
        if (this.handleWrite()) {
            this.channelWrite(b);
            System.out.print("<");
        }
        if (b.remaining() > 0) {
            if (!this.bufferQueue.offer(b)) {
                throw new IOException("Buffers are full, message could not be sent to" + this.socketChannel.socket().getRemoteSocketAddress());
            }
            System.out.print(".");
            return false;
        }
        return true;
    }

    public boolean hasBufferedData() {
        return !this.bufferQueue.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        Object object = this.bufferQueueMutex;
        synchronized (object) {
            ByteBuffer buffer = (ByteBuffer)this.bufferQueue.peek();
            while (buffer != null) {
                System.out.print("!<");
                this.channelWrite(buffer);
                if (buffer.remaining() > 0) {
                    System.out.print(".");
                    return false;
                }
                this.bufferQueue.poll();
                buffer = (ByteBuffer)this.bufferQueue.peek();
            }
            return true;
        }
    }

    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    public void startHandshake(HandshakeBuilder handshakedata) throws IOException, InvalidHandshakeException {
        if (this.handshakeComplete) {
            throw new IllegalStateException("Handshake has allready been sent.");
        }
        this.handshakerequest = handshakedata;
        this.channelWrite(this.draft.createHandshake(this.draft.postProcessHandshakeRequestAsClient(handshakedata), this.role));
    }

    protected void channelWrite(ByteBuffer buf) throws IOException {
        this.socketChannel.write(buf);
    }

    protected void channelWrite(List<ByteBuffer> bufs) throws IOException {
        for (ByteBuffer b : bufs) {
            this.channelWrite(b);
        }
    }

    protected void open() {
        this.handshakeComplete = true;
        this.wsl.onOpen(this);
    }

    public int getPort() {
        return this.socketChannel.socket().getLocalPort();
    }

    public static byte[] utf8Bytes(String s) {
        try {
            return s.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 Charset not available");
        }
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public Draft getDraft() {
        return this.draft;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Role {
        CLIENT,
        SERVER;

    }
}

