/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket;

import com.netiq.websocket.FrameBuilder;
import com.netiq.websocket.Framedata;
import com.netiq.websocket.WebSocket;
import com.netiq.websocket.exceptions.InvalidFrameException;
import java.nio.ByteBuffer;

public class FramedataImpl1
implements FrameBuilder {
    private static byte[] emptyarray = new byte[0];
    private boolean fin;
    private Framedata.Opcode optcode;
    private ByteBuffer unmaskedpayload;
    private boolean transferemasked;

    public FramedataImpl1() {
    }

    public FramedataImpl1(Framedata.Opcode op) {
        this.optcode = op;
        this.unmaskedpayload = ByteBuffer.wrap(emptyarray);
    }

    public boolean isFin() {
        return this.fin;
    }

    public Framedata.Opcode getOpcode() {
        return this.optcode;
    }

    public boolean getTransfereMasked() {
        return this.transferemasked;
    }

    public byte[] getPayloadData() {
        return this.unmaskedpayload.array();
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    public void setOptcode(Framedata.Opcode optcode) {
        this.optcode = optcode;
    }

    public void setPayload(byte[] payload) {
        this.unmaskedpayload = ByteBuffer.wrap(payload);
    }

    public void setTransferemasked(boolean transferemasked) {
        this.transferemasked = transferemasked;
    }

    public void append(Framedata nextframe) throws InvalidFrameException {
        if (this.unmaskedpayload == null) {
            this.unmaskedpayload = ByteBuffer.wrap(nextframe.getPayloadData());
        } else {
            ByteBuffer tmp = ByteBuffer.allocate(nextframe.getPayloadData().length + this.unmaskedpayload.capacity());
            tmp.put(this.unmaskedpayload.array());
            tmp.put(nextframe.getPayloadData());
        }
    }

    public String toString() {
        return "Framedata{ optcode:" + (Object)((Object)this.getOpcode()) + ", fin:" + this.isFin() + ", masked:" + this.getTransfereMasked() + ", payloadlength:" + this.unmaskedpayload.limit() + ", payload:" + WebSocket.utf8Bytes(new String(this.unmaskedpayload.array())) + "}";
    }
}

