/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.livereload;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.livereload.LiveReloadEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.FileSystems;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.Paths;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.WatchService;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class LiveReloadFileWatcher
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(LiveReloadFileWatcher.class);
    private static final Set<String> EXTENSIONS = new HashSet<String>(){
        {
            this.add("css");
            this.add("js");
            this.add("png");
            this.add("gif");
            this.add("jpg");
            this.add("vm");
            this.add("html");
            this.add("htm");
            this.add("ftl");
            this.add("soy");
            this.add("less");
        }
    };
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    private final WatchService watchService;
    private final EventPublisher eventPublisher;
    private final Map<WatchKey, Path> keyedPaths;

    public LiveReloadFileWatcher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.watchService = FileSystems.getDefault().newWatchService();
        this.keyedPaths = new HashMap<WatchKey, Path>();
    }

    public void afterPropertiesSet() throws Exception {
        this.addRoots(System.getProperty("plugin.resource.directories"));
        Runnable task = new Runnable(){

            @Override
            public void run() {
                LiveReloadFileWatcher.this.startWatching();
            }
        };
        this.exec.execute(task);
    }

    private void startWatching() {
        log.debug("starting file watcher...");
        while (!this.exec.isShutdown()) {
            WatchKey signalledKey;
            try {
                signalledKey = this.watchService.take();
            }
            catch (InterruptedException ix) {
                continue;
            }
            catch (ClosedWatchServiceException cwse) {
                log.debug("watch service closed, terminating.");
                break;
            }
            List<WatchEvent<?>> list = signalledKey.pollEvents();
            signalledKey.reset();
            Path parentPath = this.keyedPaths.get(signalledKey);
            if (null == parentPath) continue;
            HashSet<String> updatePaths = new HashSet<String>();
            for (WatchEvent<?> e : list) {
                String message = "";
                if (e.kind() == StandardWatchEventKind.ENTRY_CREATE || e.kind() == StandardWatchEventKind.ENTRY_DELETE || e.kind() == StandardWatchEventKind.ENTRY_MODIFY) {
                    Path context = (Path)e.context();
                    String fullPath = parentPath.toString() + "/" + context.toString();
                    if (EXTENSIONS.contains(FilenameUtils.getExtension((String)fullPath))) {
                        updatePaths.add(fullPath);
                        message = context.toString() + " " + e.kind().name();
                    }
                } else if (e.kind() == StandardWatchEventKind.OVERFLOW) {
                    message = "OVERFLOW: more changes happened than we could retrieve";
                }
                if (!StringUtils.isNotBlank((String)message)) continue;
                log.debug(message);
            }
            for (String updatedPath : updatePaths) {
                this.eventPublisher.publish((Object)new LiveReloadEvent(updatedPath));
            }
        }
    }

    public void destroy() throws Exception {
        this.exec.shutdown();
        this.watchService.close();
    }

    private void addRoots(String dirs) {
        if (dirs != null) {
            for (String dir : dirs.split(",")) {
                File resourceDir = new File(dir.trim());
                if (!resourceDir.exists()) {
                    log.warn("Plugin resource directory '" + resourceDir.getPath().toString() + "' does not exist. Ignoring");
                    continue;
                }
                try {
                    ResourceDirectoryWalker walker = new ResourceDirectoryWalker();
                    List<File> allDirs = walker.getResourceDirs(resourceDir);
                    for (File watchDir : allDirs) {
                        log.info("Found plugin reload target directory '{}'", (Object)watchDir);
                        Path watchPath = Paths.get(watchDir.getCanonicalPath());
                        WatchKey key = watchPath.register(this.watchService, StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_DELETE, StandardWatchEventKind.ENTRY_MODIFY);
                        this.keyedPaths.put(key, watchPath);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class ResourceDirectoryWalker
    extends DirectoryWalker {
        private ResourceDirectoryWalker() {
        }

        public List<File> getResourceDirs(File startDir) throws IOException {
            ArrayList<File> results = new ArrayList<File>();
            this.walk(startDir, results);
            return results;
        }

        protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
            if (directory.isDirectory() && directory.exists() && !results.contains(directory)) {
                results.add(directory);
                return true;
            }
            return false;
        }
    }
}

