/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev.rest.resources;

import com.atlassian.fastdev.ReloadHandler;
import com.atlassian.fastdev.maven.MavenTaskManager;
import com.atlassian.fastdev.rest.FastdevUriBuilder;
import com.atlassian.fastdev.rest.representations.MavenTaskCollectionRepresentation;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Iterator;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/reload")
@AnonymousAllowed
public class ReloadResource {
    private final MavenTaskManager taskManager;
    private final FastdevUriBuilder uriBuilder;
    private final ReloadHandler reloadHandler;

    public ReloadResource(MavenTaskManager taskManager, FastdevUriBuilder uriBuilder, ReloadHandler reloadHandler) {
        this.taskManager = (MavenTaskManager)Preconditions.checkNotNull((Object)taskManager, (Object)"taskManager");
        this.uriBuilder = (FastdevUriBuilder)Preconditions.checkNotNull((Object)uriBuilder, (Object)"uriBuilder");
        this.reloadHandler = (ReloadHandler)Preconditions.checkNotNull((Object)reloadHandler, (Object)"reloadHandler");
    }

    @POST
    @Produces(value={"application/json"})
    public Response triggerReloadTask() throws IOException {
        Iterator<String> iterator = this.reloadHandler.reloadPlugins().iterator();
        if (iterator.hasNext()) {
            String output = iterator.next();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String json = gson.toJson(new MavenTaskCollectionRepresentation(this.taskManager, this.uriBuilder));
            return Response.ok((Object)json, (String)"application/json").build();
        }
        return Response.noContent().build();
    }

    @Path(value="/withtests")
    @POST
    @Produces(value={"application/json"})
    public Response triggerReloadWithTestsTask() throws IOException {
        Iterator<String> iterator = this.reloadHandler.reloadPluginsWithTests().iterator();
        if (iterator.hasNext()) {
            String output = iterator.next();
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            String json = gson.toJson(new MavenTaskCollectionRepresentation(this.taskManager, this.uriBuilder));
            return Response.ok((Object)json, (String)"application/json").build();
        }
        return Response.noContent().build();
    }
}

