/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev.maven;

import com.atlassian.fastdev.ScanResult;
import com.atlassian.fastdev.maven.CLIMavenTask;
import com.atlassian.fastdev.maven.CLIProcess;
import com.atlassian.fastdev.maven.DefaultMavenTask;
import com.atlassian.fastdev.maven.MavenTask;
import com.atlassian.fastdev.maven.MavenTaskError;
import com.atlassian.fastdev.util.Either;
import com.atlassian.fastdev.util.Option;
import com.atlassian.fastdev.util.Pair;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class MavenTaskManager
implements DisposableBean {
    private static final long DEFAULT_AVERAGE_BUILD_TIME = 0L;
    public static final String ANY_PLUGIN_KEY = "any-plugin-key";
    public final Logger LOG = LoggerFactory.getLogger(MavenTaskManager.class);
    private final ExecutorService executorService;
    private final ConcurrentMap<File, MavenTask> inFlightTasks;
    private final ConcurrentMap<File, CLIProcess> cliProcesses;
    private final ConcurrentMap<UUID, MavenTask> tasks;
    private final ConcurrentMap<UUID, MavenTask> completedTasks;
    private final ConcurrentMap<File, RunningAverage> averageBuildTimes;
    private final Iterable<Pair<String, String>> mavenCommands = ImmutableList.of(Pair.pair("ATLAS_HOME", "/apache-maven/bin/mvn"), Pair.pair("M2_HOME", "/bin/mvn"));

    public MavenTaskManager() {
        this(Executors.newFixedThreadPool(8, new MavenThreadFactory()));
    }

    public MavenTaskManager(ExecutorService executorService) {
        this.executorService = executorService;
        this.tasks = new MapMaker().makeMap();
        this.inFlightTasks = new MapMaker().makeMap();
        this.averageBuildTimes = new MapMaker().makeMap();
        this.completedTasks = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build().asMap();
        this.cliProcesses = new MapMaker().makeMap();
    }

    String getMavenCommand() {
        for (String string : Option.option(System.getProperty("fastdev.mvn.command"))) {
            if (new File(string).exists()) {
                return string;
            }
            this.LOG.warn("Cannot use maven command " + string + " from property " + "fastdev.mvn.command" + " because it does not exist");
        }
        for (Pair pair : this.mavenCommands) {
            for (String path : Option.option(System.getenv((String)pair.first()))) {
                File cmd = new File(path, (String)pair.second());
                if (cmd.exists()) {
                    return cmd.getAbsolutePath();
                }
                this.LOG.warn("Cannot use maven command " + cmd.getAbsolutePath() + " from property " + (String)pair.first() + " because it does not exist");
            }
        }
        return "mvn";
    }

    public Either<MavenTaskError, MavenTask> createTask(File buildRoot, List<String> commands) {
        if (!buildRoot.isDirectory() || !new File(buildRoot, "pom.xml").exists()) {
            this.LOG.error("Failed to execute build: " + buildRoot.getPath() + " is not a maven root");
            return Either.left(MavenTaskError.INVALID_BUILD_ROOT);
        }
        UUID uuid = UUID.randomUUID();
        DefaultMavenTask task = new DefaultMavenTask(uuid, buildRoot, commands, this, this.executorService);
        return this.add(task);
    }

    public Either<MavenTaskError, MavenTask> createCliTask(ScanResult result, String command, List<String> cliArgs) {
        File buildRoot = result.getBuildRoot();
        if (!buildRoot.isDirectory() || !result.getRootPom().exists()) {
            this.LOG.error("Failed to execute build: " + buildRoot.getPath() + " is not a maven root");
            return Either.left(MavenTaskError.INVALID_BUILD_ROOT);
        }
        UUID uuid = UUID.randomUUID();
        CLIMavenTask task = new CLIMavenTask(uuid, result, cliArgs, command, this, this.executorService);
        return this.add(task);
    }

    boolean hasCliProcess(File buildRoot) {
        return this.cliProcesses.containsKey(buildRoot);
    }

    CLIProcess getCliProcess(File buildRoot) {
        return (CLIProcess)this.cliProcesses.get(buildRoot);
    }

    void removeCliProcess(File buildRoot, CLIProcess process) {
        this.cliProcesses.remove(buildRoot, process);
    }

    void addCliProcess(File buildRoot, CLIProcess process) {
        this.cliProcesses.put(buildRoot, process);
    }

    boolean cliPortTaken(Integer port) {
        boolean taken = false;
        for (CLIProcess cli : this.cliProcesses.values()) {
            if (!cli.getPort().equals(port)) continue;
            taken = true;
            break;
        }
        return taken;
    }

    public MavenTask getTask(UUID uuid) {
        return (MavenTask)this.tasks.get(uuid);
    }

    public MavenTask getTaskForRoot(File file) {
        return (MavenTask)this.inFlightTasks.get(file);
    }

    public MavenTask getCompletedTask(UUID uuid) {
        return (MavenTask)this.completedTasks.get(uuid);
    }

    public Iterable<MavenTask> getAllTasks() {
        return ImmutableList.copyOf(this.tasks.values());
    }

    private Either<MavenTaskError, MavenTask> add(MavenTask task) {
        MavenTask existing = this.inFlightTasks.putIfAbsent(task.getBuildRoot(), task);
        if (existing != null) {
            this.LOG.warn("Ignoring build: " + task.getBuildRoot().getAbsolutePath() + " as a plugin install is currently in progress");
            return Either.left(MavenTaskError.PLUGIN_INSTALL_IN_PROGRESS);
        }
        this.tasks.put(task.getUuid(), task);
        return Either.right(task);
    }

    void remove(MavenTask task) {
        this.inFlightTasks.remove(task.getBuildRoot(), task);
        this.completedTasks.putIfAbsent(task.getUuid(), task);
        this.tasks.remove(task.getUuid(), task);
    }

    long averageBuildTime(File buildRoot) {
        RunningAverage ave = this.averageBuildTimes.putIfAbsent(buildRoot, new RunningAverage(0, 0L));
        if (ave == null) {
            return 0L;
        }
        return ave.average();
    }

    void recordBuildTime(File buildRoot, long latest) {
        boolean replaced = false;
        while (!replaced) {
            RunningAverage oldAverage = (RunningAverage)this.averageBuildTimes.get(buildRoot);
            replaced = this.averageBuildTimes.replace(buildRoot, oldAverage, oldAverage.adjust(latest));
        }
    }

    public void destroy() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.LOG.warn("Timed out while waiting for Maven executor to shutdown.");
            }
        }
        catch (InterruptedException e) {
            this.LOG.warn("Interrupted while waiting for Maven executor to shutdown.");
        }
        for (CLIProcess process : this.cliProcesses.values()) {
            process.getProcess().destroy();
        }
    }

    private static class MavenThreadFactory
    implements ThreadFactory {
        private final AtomicLong id = new AtomicLong();

        private MavenThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName(String.format("FastDev-MavenTask-%d", this.id.getAndIncrement()));
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class RunningAverage {
        private final int n;
        private final long total;

        public RunningAverage(int n, long total) {
            this.n = n;
            this.total = total;
        }

        public long average() {
            if (this.n == 0) {
                return 0L;
            }
            return this.total / (long)this.n;
        }

        public RunningAverage adjust(long latest) {
            return new RunningAverage(this.n + 1, this.total + latest);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunningAverage that = (RunningAverage)o;
            if (this.n != that.n) {
                return false;
            }
            return this.total == that.total;
        }

        public int hashCode() {
            int result = this.n;
            result = 31 * result + (int)(this.total ^ this.total >>> 32);
            return result;
        }
    }
}

