/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev.maven;

import com.atlassian.fastdev.maven.MavenTask;
import com.atlassian.fastdev.maven.MavenTaskManager;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang.SystemUtils;

public class DefaultMavenTask
implements MavenTask {
    private final MavenTaskManager mavenTaskManager;
    private final ExecutorService executorService;
    private final File buildRoot;
    private final ProcessBuilder builder;
    private final UUID uuid;
    private final ConcurrentLinkedQueue<String> output;
    private volatile Integer exitCode;
    private final long currentAverage;
    private volatile long startTime;

    DefaultMavenTask(UUID uuid, File buildRoot, List<String> commands, MavenTaskManager mavenTaskManager, ExecutorService executorService) {
        this.mavenTaskManager = mavenTaskManager;
        this.executorService = executorService;
        ImmutableList.Builder commandsBuilder = ImmutableList.builder();
        if (SystemUtils.IS_OS_WINDOWS) {
            commandsBuilder.add((Object[])new String[]{"cmd", "/c"});
        }
        commandsBuilder.add((Object)mavenTaskManager.getMavenCommand());
        commandsBuilder.addAll(commands);
        this.builder = new ProcessBuilder((List<String>)commandsBuilder.build());
        this.builder.directory(buildRoot);
        this.builder.environment().remove("MAVEN_COLOR");
        this.uuid = uuid;
        this.output = new ConcurrentLinkedQueue();
        this.buildRoot = buildRoot;
        this.currentAverage = mavenTaskManager.averageBuildTime(buildRoot);
    }

    @Override
    public File getBuildRoot() {
        return this.buildRoot;
    }

    @Override
    public long getAverageTaskTime() {
        return this.currentAverage;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Iterable<String> getOutput() {
        return ImmutableList.copyOf(this.output);
    }

    @Override
    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(Integer code) {
        this.exitCode = code;
    }

    @Override
    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public Future<Integer> start() {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                try {
                    String lineRead;
                    Process process = DefaultMavenTask.this.builder.start();
                    ((DefaultMavenTask)DefaultMavenTask.this).mavenTaskManager.LOG.info("Maven process executed as : " + Joiner.on((String)" ").join(DefaultMavenTask.this.builder.command()));
                    DefaultMavenTask.this.startTime = System.currentTimeMillis();
                    InputStreamReader isr = new InputStreamReader(process.getInputStream());
                    BufferedReader br = new BufferedReader(isr);
                    while ((lineRead = br.readLine()) != null) {
                        DefaultMavenTask.this.output.add(lineRead);
                    }
                    process.waitFor();
                    DefaultMavenTask.this.exitCode = process.exitValue();
                    DefaultMavenTask.this.mavenTaskManager.remove(DefaultMavenTask.this);
                    DefaultMavenTask.this.mavenTaskManager.recordBuildTime(DefaultMavenTask.this.buildRoot, System.currentTimeMillis() - DefaultMavenTask.this.startTime);
                    return process.exitValue();
                }
                catch (Exception e) {
                    ((DefaultMavenTask)DefaultMavenTask.this).mavenTaskManager.LOG.error("Maven execution failed", (Throwable)e);
                    throw e;
                }
            }
        });
    }
}

