/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev;

import com.atlassian.fastdev.AutoReloadFilter;
import com.atlassian.fastdev.ScanResult;
import com.atlassian.fastdev.maven.MavenTask;
import com.atlassian.fastdev.maven.MavenTaskManager;
import com.atlassian.fastdev.util.Option;
import com.atlassian.fastdev.util.PomCLIChecker;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginReloader {
    private final Logger LOG = LoggerFactory.getLogger(AutoReloadFilter.class);
    private final ApplicationProperties applicationProperties;
    private final MavenTaskManager taskManager;
    private final ConcurrentMap<String, Boolean> useCliForPom;

    public PluginReloader(ApplicationProperties applicationProperties, MavenTaskManager taskManager) {
        this.applicationProperties = applicationProperties;
        this.taskManager = taskManager;
        this.useCliForPom = new MapMaker().makeMap();
    }

    public void pluginInstall(ScanResult result) {
        if (this.useCli(result).booleanValue()) {
            this.pluginInstallViaCLI(result);
        } else {
            this.pluginInstallViaMaven(result);
        }
    }

    public void pluginInstallWithTests(ScanResult result) {
        if (this.useCli(result).booleanValue()) {
            this.pluginInstallWithTestsViaCLI(result);
        } else {
            this.pluginInstallWithTestsViaMaven(result);
        }
    }

    private void pluginInstallViaMaven(ScanResult result) {
        URI baseUri = URI.create(this.applicationProperties.getBaseUrl());
        int httpPort = baseUri.getPort();
        String contextPath = baseUri.getPath();
        File buildRoot = this.getBuildRoot(result);
        ImmutableList.Builder<String> args = this.getBaseArgs(httpPort, contextPath);
        this.startTasks(buildRoot, args);
    }

    private void pluginInstallViaCLI(ScanResult result) {
        URI baseUri = URI.create(this.applicationProperties.getBaseUrl());
        int httpPort = baseUri.getPort();
        String contextPath = baseUri.getPath();
        String host = baseUri.getHost();
        ImmutableList.Builder<String> args = this.getCliArgs(httpPort, contextPath, host);
        this.startCliTasks(result, "pi", args);
    }

    private void pluginInstallWithTestsViaMaven(ScanResult result) {
        URI baseUri = URI.create(this.applicationProperties.getBaseUrl());
        int httpPort = baseUri.getPort();
        String contextPath = baseUri.getPath();
        File buildRoot = this.getBuildRoot(result);
        ImmutableList.Builder<String> args = this.getBaseArgsWithTests(httpPort, contextPath);
        this.startTasks(buildRoot, args);
    }

    private void pluginInstallWithTestsViaCLI(ScanResult result) {
        URI baseUri = URI.create(this.applicationProperties.getBaseUrl());
        int httpPort = baseUri.getPort();
        String contextPath = baseUri.getPath();
        String host = baseUri.getHost();
        ImmutableList.Builder<String> args = this.getCliArgs(httpPort, contextPath, host);
        this.startCliTasks(result, "tpi", args);
    }

    private void startTasks(File buildRoot, ImmutableList.Builder<String> args) {
        for (MavenTask task : this.taskManager.createTask(buildRoot, (List<String>)args.build()).right()) {
            this.LOG.info("Executing mvn process in " + buildRoot.getPath());
            task.start();
        }
    }

    private void startCliTasks(ScanResult result, String command, ImmutableList.Builder<String> args) {
        for (MavenTask task : this.taskManager.createCliTask(result, command, (List<String>)args.build()).right()) {
            this.LOG.info("Executing mvn process in " + result.getBuildRoot().getPath());
            task.start();
        }
    }

    private Boolean useCli(ScanResult result) {
        File rootPom = result.getRootPom();
        boolean pomChanged = result.isPomChanged();
        if (pomChanged || !this.useCliForPom.containsKey(rootPom.getAbsolutePath())) {
            this.useCliForPom.put(rootPom.getAbsolutePath(), PomCLIChecker.useFastdevCli(rootPom));
        }
        return (Boolean)this.useCliForPom.get(rootPom.getAbsolutePath());
    }

    protected File getBuildRoot(ScanResult result) {
        if (!result.getBuildRoot().isDirectory() || !result.getRootPom().exists()) {
            this.LOG.warn(result.getBuildRoot().getPath() + " does not contain pom.xml. Skipping");
        }
        return result.getBuildRoot();
    }

    protected ImmutableList.Builder<String> getBaseArgs(int httpPort, String contextPath) {
        String ampsVersion = this.getAmpsVersion();
        ImmutableList.Builder args = ImmutableList.builder().add((Object[])new String[]{"com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "copy-bundled-dependencies", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "compress-resources", "resources:resources", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "filter-plugin-descriptor", "compile", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "generate-manifest", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "jar", "org.apache.maven.plugins:maven-install-plugin:install", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "install", "-Dhttp.port=" + httpPort, "-Dcontext.path=" + contextPath});
        for (String username : Option.option(System.getProperty("fastdev.install.username"))) {
            args.add((Object)("-Dusername=" + username));
        }
        for (String password : Option.option(System.getProperty("fastdev.install.password"))) {
            args.add((Object)("-Dpassword=" + password));
        }
        return args;
    }

    protected ImmutableList.Builder<String> getBaseArgsWithTests(int httpPort, String contextPath) {
        String ampsVersion = this.getAmpsVersion();
        ImmutableList.Builder args = ImmutableList.builder().add((Object[])new String[]{"com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "copy-bundled-dependencies", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "compress-resources", "resources:resources", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "filter-plugin-descriptor", "compile", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "generate-manifest", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "copy-test-bundled-dependencies", "resources:testResources", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "filter-test-plugin-descriptor", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "generate-test-manifest", "org.apache.maven.plugins:maven-compiler-plugin:" + ampsVersion + "testCompile", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "jar", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "test-jar", "org.apache.maven.plugins:maven-install-plugin:install", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "install", "com.atlassian.maven.plugins:maven-amps-plugin:" + ampsVersion + "test-install", "-Dhttp.port=" + httpPort, "-Dcontext.path=" + contextPath});
        for (String username : Option.option(System.getProperty("fastdev.install.username"))) {
            args.add((Object)("-Dusername=" + username));
        }
        for (String password : Option.option(System.getProperty("fastdev.install.password"))) {
            args.add((Object)("-Dpassword=" + password));
        }
        return args;
    }

    protected ImmutableList.Builder<String> getCliArgs(int httpPort, String contextPath, String host) {
        String ampsVersion = this.getAmpsVersion();
        ImmutableList.Builder args = ImmutableList.builder().add((Object[])new String[]{"com.atlassian.maven.plugins:maven-amps-dispatcher-plugin:" + ampsVersion + "cli", "-Dhttp.port=" + httpPort, "-Dcontext.path=" + contextPath});
        return args;
    }

    private String getAmpsVersion() {
        String sdkVersion = System.getProperty("atlassian.sdk.version", "");
        String ampsVersion = "";
        if (StringUtils.isNotBlank((String)sdkVersion)) {
            ampsVersion = sdkVersion + ":";
        }
        return ampsVersion;
    }

    protected String getAmpsProduct() {
        String ampsProduct = "amps";
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("jira")) {
            ampsProduct = "jira";
        }
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("confluence")) {
            ampsProduct = "confluence";
        }
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("bamboo")) {
            ampsProduct = "bamboo";
        }
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("crowd")) {
            ampsProduct = "crowd";
        }
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("stash")) {
            ampsProduct = "stash";
        }
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("fisheye") || this.applicationProperties.getDisplayName().equalsIgnoreCase("crucible") || this.applicationProperties.getDisplayName().equalsIgnoreCase("fecru")) {
            ampsProduct = "fecru";
        }
        if (this.applicationProperties.getDisplayName().equalsIgnoreCase("refapp")) {
            ampsProduct = "refapp";
        }
        return ampsProduct;
    }
}

