/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev.rest.resources;

import com.atlassian.fastdev.maven.MavenTaskManager;
import com.atlassian.fastdev.rest.FastdevUriBuilder;
import com.atlassian.fastdev.rest.representations.MavenTaskCollectionRepresentation;
import com.atlassian.fastdev.rest.representations.MavenTaskRepresentation;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/tasks")
@AnonymousAllowed
public class MavenTaskResource {
    private final MavenTaskManager taskManager;
    private final FastdevUriBuilder uriBuilder;

    public MavenTaskResource(MavenTaskManager taskManager, FastdevUriBuilder uriBuilder) {
        this.taskManager = (MavenTaskManager)Preconditions.checkNotNull((Object)taskManager, (Object)"taskManager");
        this.uriBuilder = (FastdevUriBuilder)Preconditions.checkNotNull((Object)uriBuilder, (Object)"uriBuilder");
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTaskCollection() {
        return Response.ok((Object)new MavenTaskCollectionRepresentation(this.taskManager, this.uriBuilder)).build();
    }

    @GET
    @Path(value="{uuid}")
    public Response getTask(@PathParam(value="uuid") String uuid) {
        MavenTaskManager.MavenTask task = this.taskManager.getTask(UUID.fromString(uuid));
        if (task == null && (task = this.taskManager.getCompletedTask(UUID.fromString(uuid))) == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)new MavenTaskRepresentation(task, this.uriBuilder)).type("application/json").build();
    }
}

