/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetScanner {
    private static final String POM_FILENAME = "pom.xml";
    private static final Logger log = LoggerFactory.getLogger(TargetScanner.class);
    private static final Set<String> NO_RELOAD_DIRS = Sets.union((Set)Sets.newHashSet((Object[])new String[]{".svn"}), TargetScanner.fetchExtraNoReloadDirectories());
    private final Map<File, Set<ScannedFile>> roots;
    private final Set<String> NO_RELOAD_EXTENSIONS = Sets.union((Set)Sets.newHashSet((Object[])new String[]{"js", "vm", "vmd", "fm", "ftl", "html", "png", "jpeg", "gif", "css"}), TargetScanner.fetchExtraNoReloadExtensions());
    private final Set<File> NO_RELOAD_FILES = TargetScanner.fetchExtraNoReloadFiles();

    public TargetScanner() {
        this.roots = new LinkedHashMap<File, Set<ScannedFile>>();
        this.addRoots(System.getProperty("plugin.resource.directories"), true);
        this.addRoots(System.getProperty("plugin.root.directories"), false);
    }

    private void addRoots(String dirs, boolean isResourceDir) {
        if (dirs != null) {
            for (String dir : dirs.split(",")) {
                File file;
                try {
                    File pluginDir = new File(dir.trim());
                    if (!pluginDir.exists()) {
                        log.warn("Plugin resource directory '" + pluginDir.getPath().toString() + "' does not exist. Ignoring");
                        continue;
                    }
                    if (isResourceDir) {
                        File parent = pluginDir.getParentFile();
                        if (parent == null || !parent.exists()) {
                            log.warn("Plugin resource directory '" + pluginDir.getPath().toString() + "' does not exist. Ignoring");
                            continue;
                        }
                        file = parent.getCanonicalFile();
                    } else {
                        File pom = new File(pluginDir, POM_FILENAME);
                        if (!pom.exists()) {
                            log.warn("Plugin source directory '" + pluginDir.getPath() + "' does not contain a pom.xml file. Ignoring");
                            continue;
                        }
                        File srcMainDir = new File(new File(pluginDir, "src"), "main");
                        if (!srcMainDir.exists()) {
                            log.warn("Plugin source directory '" + srcMainDir.getPath() + "' does not exist. Ignoring");
                            continue;
                        }
                        file = srcMainDir.getCanonicalFile();
                    }
                }
                catch (IOException e) {
                    log.warn("Unable to find plugin target directory for '" + dir + "'", (Throwable)e);
                    continue;
                }
                if (!file.exists() || this.roots.containsKey(file)) continue;
                log.info("Found plugin reload target directory '{}'", (Object)file);
                HashSet<ScannedFile> files = new HashSet<ScannedFile>();
                TargetScanner.scanRoot(file, files);
                this.roots.put(file, files);
            }
        }
    }

    private static Set<String> fetchExtraNoReloadExtensions() {
        String extensions = System.getProperty("fastdev.no.reload.extensions");
        if (extensions != null) {
            return ImmutableSet.copyOf(Arrays.asList(extensions.split(",")));
        }
        return ImmutableSet.of();
    }

    private static Set<File> fetchExtraNoReloadFiles() {
        String files = System.getProperty("fastdev.no.reload.files");
        if (files == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String file : files.split(",")) {
            try {
                builder.add((Object)new File(file).getCanonicalFile());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return builder.build();
    }

    private static Set<String> fetchExtraNoReloadDirectories() {
        String dirs = System.getProperty("fastdev.no.reload.directories");
        if (dirs != null) {
            return ImmutableSet.copyOf(Arrays.asList(dirs.split(",")));
        }
        return ImmutableSet.of();
    }

    public Set<File> getRoots() {
        return ImmutableSet.copyOf(this.roots.keySet());
    }

    public Set<File> scan() {
        ImmutableSet.Builder rootsToReload = ImmutableSet.builder();
        for (File root : this.getRoots()) {
            HashSet<ScannedFile> files = new HashSet<ScannedFile>();
            TargetScanner.scanRoot(root, files);
            Set<ScannedFile> changedFiles = TargetScanner.symmetricDifference(files, this.roots.get(root));
            this.roots.put(root, files);
            if (!this.changedFilesRequireReload(changedFiles)) continue;
            rootsToReload.add((Object)root);
        }
        return rootsToReload.build();
    }

    private static <T> Set<T> symmetricDifference(Set<T> setA, Set<T> setB) {
        Sets.SetView either = Sets.union(setA, setB);
        Sets.SetView both = Sets.intersection(setA, setB);
        return Sets.difference((Set)either, (Set)both);
    }

    private boolean changedFilesRequireReload(Set<ScannedFile> changedFiles) {
        for (ScannedFile scannedFile : changedFiles) {
            if (this.NO_RELOAD_FILES.contains(scannedFile.getFile())) continue;
            String name = scannedFile.getFile().getName();
            String extension = "";
            int ind = name.lastIndexOf(46);
            if (ind > -1) {
                extension = name.substring(ind + 1);
            }
            if (scannedFile.getFile().isDirectory() || this.NO_RELOAD_EXTENSIONS.contains(extension)) continue;
            return true;
        }
        return false;
    }

    private static void scanRoot(File root, Set<ScannedFile> files) {
        if (root.isDirectory() && TargetScanner.shouldBeScanned(root)) {
            TargetScanner.addScannedFile(new File(root.getParentFile().getParentFile(), POM_FILENAME), files);
            TargetScanner.scanDir(root, files);
        }
    }

    private static void scanDir(File dir, Set<ScannedFile> files) {
        if (dir.isDirectory() && TargetScanner.shouldBeScanned(dir)) {
            for (File file : dir.listFiles()) {
                TargetScanner.addScannedFile(file, files);
                TargetScanner.scanDir(file, files);
            }
        }
    }

    private static boolean shouldBeScanned(File dir) {
        String dirName = !IOCase.SYSTEM.isCaseSensitive() ? dir.getName().toLowerCase() : dir.getName();
        return !NO_RELOAD_DIRS.contains(dirName);
    }

    private static void addScannedFile(File file, Set<ScannedFile> files) {
        try {
            files.add(new ScannedFile(file.getCanonicalFile()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ScannedFile {
        private final Long lastModified;
        private final File file;

        public ScannedFile(String filename) {
            this(new File(filename));
        }

        public ScannedFile(File file) {
            this.file = file;
            this.lastModified = file.lastModified();
        }

        public File getFile() {
            return this.file;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScannedFile that = (ScannedFile)o;
            if (!this.file.equals(that.file)) {
                return false;
            }
            return this.lastModified.equals(that.lastModified);
        }

        public int hashCode() {
            int result = this.lastModified.hashCode();
            result = 31 * result + this.file.hashCode();
            return result;
        }
    }
}

