jQuery(document).ready(function(){
    
    var baseurl = "";
    
    if(AJS.hasOwnProperty('contextPath'))
    {
        baseurl = AJS.contextPath();
    }
    else if(contextPath)
    {
        baseurl = contextPath;
    }
    
    var lrurl = baseurl + '/download/resources/com.atlassian.labs.fastdev-plugin/js/livereload.js?host=localhost&port=35730';

    var fireEvent = function(element,event){
        if (document.createEventObject){
            // dispatch for IE
            var evt = document.createEventObject();
            evt.type = event;
            element.fireEvent(event,evt)
        }
        else{
            // dispatch for firefox + others
            var evt = document.createEvent("HTMLEvents");
            evt.initEvent(event, true, true ); // event type,bubbling,cancelable
            element.dispatchEvent(evt);
        }
    }
    
    var enableLiveReload = function()
    {
        if(localStorage)
        {
            localStorage.setItem("atlassianLiveReload",window.location.pathname);
        }

        var lrscript = document.createElement('script');
        lrscript.type = 'text/javascript';
        lrscript.id = 'lrjstag';
        document.body.appendChild(lrscript);
        lrscript.src = lrurl;
    }
    
    var disableLiveReload = function()
    {
        if(localStorage)
        {
            localStorage.removeItem("atlassianLiveReload");
        }
        fireEvent(document,'LiveReloadShutDown');
        jQuery('#lrjstag').remove();
    }
    
    var initialCheck = "";
    var enableIt = false;
    if(localStorage)
    {
        var lrPath = localStorage.getItem("atlassianLiveReload");
        if(lrPath === window.location.pathname)
        {
            initialCheck = " checked";
            enableIt = true;
        }
    }
    
    jQuery('body').append(
        '<div id="lrtoggleDiv"><input type="checkbox" name="lrtoggle" id="lrtoggle"' + initialCheck + '/> <span class="lrToggleLabel">enable live reload</span></div>'
    );
    
    jQuery('#lrtoggle').click(function(){
        if(jQuery(this).is(':checked'))
        {
            enableLiveReload();
        }
        else
        {
            disableLiveReload();
        }
    });
    
    if(enableIt)
    {
        enableLiveReload();
    }
});

        
