/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.k8s.test;

import java.net.URI;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public final class ResourceNames {
    private static final String HELM_RELEASE_NAME = StringUtils.lowerCase((String)System.getProperty("helm.release.name"));

    private ResourceNames() {
    }

    public static String[] getPodNames(int podCount) {
        return (String[])IntStream.range(0, podCount).mapToObj(ResourceNames::getPodName).toArray(String[]::new);
    }

    public static String getPodName(int i) {
        return ResourceNames.getServiceName() + "-" + i;
    }

    public static String getServiceName() {
        return HELM_RELEASE_NAME;
    }

    private static String getDomain() {
        return System.getProperty("service.domain");
    }

    public static URI getIngressUri() {
        return URI.create(String.format("https://%s.%s", ResourceNames.getServiceName(), ResourceNames.getDomain()));
    }

    public static URI getPodIngressUri(int nodeIdx) {
        return URI.create(String.format("https://%s-%d.%s", ResourceNames.getServiceName(), nodeIdx, ResourceNames.getDomain()));
    }
}

