/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.k8s.test;

import com.atlassian.k8s.test.LogFetcher;
import com.atlassian.k8s.test.ResourceNames;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.SocketTimeoutException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class K8SClient
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(K8SClient.class);
    static final String NAMESPACE_NAME = System.getProperty("namespace.name", "dcng");
    private static final Duration POD_WAIT_TIME = Duration.parse(System.getProperty("podWaitTime", "PT5M"));
    private static final Duration SERVICE_WAIT_TIME = Duration.parse(System.getProperty("serviceWaitTime", "PT5M"));
    private final KubernetesClient client;
    private final LogFetcher logFetcher;

    public static K8SClient create() {
        return new K8SClient((KubernetesClient)new DefaultKubernetesClient(K8SClient.clientConfigBuilder().build()));
    }

    public OkHttpClient getHttpClient() {
        try {
            Field httpClientField = BaseClient.class.getDeclaredField("httpClient");
            httpClientField.setAccessible(true);
            return (OkHttpClient)httpClientField.get(this.client);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    static ConfigBuilder clientConfigBuilder() {
        return (ConfigBuilder)new ConfigBuilder().withNamespace(NAMESPACE_NAME);
    }

    private K8SClient(KubernetesClient client) {
        this.client = client;
        this.logFetcher = new LogFetcher(client);
    }

    public PodStatus getPodStatus(String podName) {
        return ((Pod)((PodResource)this.client.pods().withName(podName)).get()).getStatus();
    }

    public LocalPortForward portForward(String podName, int targetPort) {
        return (LocalPortForward)((PodResource)this.client.pods().withName(podName)).portForward(targetPort);
    }

    public LogFetcher logFetcher() {
        return this.logFetcher;
    }

    public int getReplicaCount() {
        return this.getStatefulSet().getSpec().getReplicas();
    }

    public void setReplicaCount(int replicaCount) {
        StatefulSet statefulSet = this.getStatefulSet();
        statefulSet.getSpec().setReplicas(Integer.valueOf(replicaCount));
        log.info("Setting replica count on statefulset to {}", (Object)replicaCount);
        this.client.apps().statefulSets().createOrReplace((Object[])new StatefulSet[]{statefulSet});
    }

    private StatefulSet getStatefulSet() {
        AppsAPIGroupDSL apps = this.client.apps();
        String serviceName = ResourceNames.getServiceName();
        StatefulSet statefulSet = (StatefulSet)((RollableScalableResource)apps.statefulSets().withName(serviceName)).get();
        return Objects.requireNonNull(statefulSet, "StatefulSet [" + serviceName + "] not found");
    }

    public void transferFileToPods(String resourcePath, String targetPath) {
        File tempFile;
        int podCount = this.getReplicaCount();
        String[] podNames = ResourceNames.getPodNames(podCount);
        try (InputStream is = this.getResourceAsStream(resourcePath);){
            tempFile = new File(Paths.get(targetPath, new String[0]).getFileName().toString() + ".tmp");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)tempFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String podName : podNames) {
            ((CopyOrReadable)((PodResource)this.client.pods().withName(podName)).file(targetPath)).upload(tempFile.toPath());
        }
        FileUtils.deleteQuietly((File)tempFile);
    }

    private InputStream getResourceAsStream(String resourcePath) {
        InputStream original = K8SClient.class.getClassLoader().getResourceAsStream(resourcePath);
        if (original != null) {
            return original;
        }
        InputStream withXmlPrefix = K8SClient.class.getClassLoader().getResourceAsStream("xml/" + resourcePath);
        if (withXmlPrefix != null) {
            return withXmlPrefix;
        }
        throw new IllegalArgumentException("Import resource with path \"" + resourcePath + "\" not found");
    }

    public void waitUntilAllPodsAreReady() throws InterruptedException {
        int podCount = this.getReplicaCount();
        Object[] podNames = ResourceNames.getPodNames(podCount);
        log.info("Waiting for pods {} to become ready", (Object)Arrays.toString(podNames));
        for (Object podName : podNames) {
            this.waitUntilPodIsReady((String)podName);
        }
    }

    public void waitUntilPodIsReady(String podName) throws InterruptedException {
        log.info("Waiting for pod {} to become ready", (Object)podName);
        ((PodResource)this.client.pods().withName(podName)).waitUntilReady(POD_WAIT_TIME.toMillis(), TimeUnit.MILLISECONDS);
        log.info("Pod {} is ready", (Object)podName);
    }

    public void waitUntilServiceIsReachable() throws InterruptedException {
        try {
            this.waitUntilAllPodsAreReady();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (KubernetesClientException e) {
            log.info("Got an exception, continuing with waiting for the service to respond", (Throwable)e);
        }
        String serviceName = ResourceNames.getServiceName();
        log.info("Waiting for service {} to become reachable", (Object)serviceName);
        Request request = new Request.Builder().url(ResourceNames.getIngressUri().toString()).build();
        OkHttpClient httpClient = this.getHttpClient();
        long endTime = System.currentTimeMillis() + SERVICE_WAIT_TIME.toMillis();
        while (true) {
            try (Response execute2 = httpClient.newCall(request).execute();){
                if (execute2.isSuccessful()) {
                    break;
                }
            }
            catch (SocketTimeoutException execute2) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (System.currentTimeMillis() > endTime) {
                throw new RuntimeException("Timeout for waiting for service " + serviceName + " exceeded.");
            }
            Thread.sleep(100L);
        }
    }

    public void dispose() {
        this.logFetcher.close();
        this.client.close();
    }

    protected void after() {
        this.dispose();
    }
}

