/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;

class RSA_OAEP {
    public static byte[] encryptCEK(RSAPublicKey pub, SecretKey cek) throws JOSEException {
        try {
            RSAEngine engine = new RSAEngine();
            OAEPEncoding cipher = new OAEPEncoding(engine);
            BigInteger mod = pub.getModulus();
            BigInteger exp = pub.getPublicExponent();
            RSAKeyParameters keyParams = new RSAKeyParameters(false, mod, exp);
            cipher.init(true, keyParams);
            int inputBlockSize = cipher.getInputBlockSize();
            int outputBlockSize = cipher.getOutputBlockSize();
            byte[] keyBytes = cek.getEncoded();
            return cipher.processBlock(keyBytes, 0, keyBytes.length);
        }
        catch (Exception e) {
            throw new JOSEException("Couldn't encrypt Content Encryption Key (CEK): " + e.getMessage(), e);
        }
    }

    public static SecretKey decryptCEK(RSAPrivateKey priv, byte[] encryptedCEK) throws JOSEException {
        try {
            RSAEngine engine = new RSAEngine();
            OAEPEncoding cipher = new OAEPEncoding(engine);
            BigInteger mod = priv.getModulus();
            BigInteger exp = priv.getPrivateExponent();
            RSAKeyParameters keyParams = new RSAKeyParameters(true, mod, exp);
            cipher.init(false, keyParams);
            byte[] secretKeyBytes = cipher.processBlock(encryptedCEK, 0, encryptedCEK.length);
            return new SecretKeySpec(secretKeyBytes, "AES");
        }
        catch (Exception e) {
            throw new JOSEException("Couldn't decrypt Content Encryption Key (CEK): " + e.getMessage(), e);
        }
    }

    private RSA_OAEP() {
    }
}

