/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.plugin.sal;

import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.jwt.applinks.ApplinkJwt;
import com.atlassian.jwt.applinks.JwtService;
import com.atlassian.jwt.core.JwtUtil;
import com.atlassian.jwt.exception.JwtParseException;
import com.atlassian.jwt.exception.JwtVerificationException;
import com.atlassian.jwt.plugin.sal.SimplePrincipal;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.Message;
import java.io.Serializable;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JwtAuthenticator
implements Authenticator {
    private final JwtService jwtService;
    private final AuthenticationController authenticationController;

    public JwtAuthenticator(JwtService jwtService, AuthenticationController authenticationController) {
        this.jwtService = jwtService;
        this.authenticationController = authenticationController;
    }

    public Authenticator.Result authenticate(HttpServletRequest request, HttpServletResponse response) {
        String jwt = JwtUtil.extractJwt(request);
        if (jwt != null) {
            return this.authenticate(request, jwt);
        }
        throw new IllegalArgumentException("This Authenticator works only with requests containing JWTs");
    }

    private Authenticator.Result authenticate(HttpServletRequest request, String jwtString) {
        try {
            ApplinkJwt jwt = this.jwtService.verifyJwt(jwtString);
            SimplePrincipal userPrincipal = new SimplePrincipal(jwt.getJwt().getSubject());
            if (this.authenticationController.canLogin((Principal)userPrincipal, request)) {
                return new Authenticator.Result.Success(JwtAuthenticator.createMessage("Authentication successful!"), (Principal)userPrincipal);
            }
            return new Authenticator.Result.Failure(JwtAuthenticator.createMessage(String.format("User [%s] and request [%s] are not a valid login combination", userPrincipal.getName(), request)));
        }
        catch (TypeNotInstalledException e) {
            return JwtAuthenticator.createError((Exception)((Object)e));
        }
        catch (JwtParseException e) {
            return JwtAuthenticator.createError(e);
        }
        catch (JwtVerificationException e) {
            return JwtAuthenticator.createFailure(e);
        }
    }

    private static Authenticator.Result.Error createError(Exception e) {
        return JwtAuthenticator.createError(e.getLocalizedMessage());
    }

    private static Authenticator.Result.Error createError(String message) {
        return new Authenticator.Result.Error(JwtAuthenticator.createMessage(message));
    }

    private static Authenticator.Result.Failure createFailure(Exception e) {
        return JwtAuthenticator.createFailure(e.getLocalizedMessage());
    }

    private static Authenticator.Result.Failure createFailure(String message) {
        return new Authenticator.Result.Failure(JwtAuthenticator.createMessage(message));
    }

    private static Message createMessage(final String message) {
        return new Message(){

            public String getKey() {
                return message;
            }

            public Serializable[] getArguments() {
                return null;
            }
        };
    }
}

