/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class JwtUtil {
    public static final String JWT_PARAM_NAME = "jwt";
    public static final String JWT_REQUEST_FLAG = "com.atlassian.jwt.is-jwt-request";
    public static final String AUTHORIZATION_HEADER = "Authorization";

    public static boolean requestContainsJwt(HttpServletRequest request) {
        return JwtUtil.extractJwt(request) != null;
    }

    public static String extractJwt(HttpServletRequest request) {
        String jwt = JwtUtil.getJwtParameter(request);
        if (jwt == null) {
            jwt = JwtUtil.getJwtHeaderValue(request);
        }
        return jwt;
    }

    private static String getJwtParameter(HttpServletRequest request) {
        String jwtParam = request.getParameter(JWT_PARAM_NAME);
        return StringUtils.isEmpty((String)jwtParam) ? null : jwtParam;
    }

    private static String getJwtHeaderValue(HttpServletRequest request) {
        Enumeration headers = request.getHeaders(AUTHORIZATION_HEADER);
        while (headers.hasMoreElements()) {
            String authzHeader = ((String)headers.nextElement()).trim();
            String first4Chars = authzHeader.substring(0, Math.min(4, authzHeader.length()));
            if (!"JWT ".equalsIgnoreCase(first4Chars)) continue;
            return authzHeader.substring(4);
        }
        return null;
    }
}

