/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.keys;

import com.atlassian.jwt.exception.JwtCannotRetrieveKeyException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class KeyUtils {
    public KeyUtils() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public RSAPrivateKey readRsaPrivateKeyFromPem(Reader reader) throws JwtCannotRetrieveKeyException {
        PEMParser pemParser = new PEMParser(reader);
        try {
            RSAPrivateKey privateKey;
            Object object = pemParser.readObject();
            PEMKeyPair pemKeyPair = (PEMKeyPair)object;
            byte[] encodedPrivateKey = pemKeyPair.getPrivateKeyInfo().getEncoded();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
            RSAPrivateKey rSAPrivateKey = privateKey = (RSAPrivateKey)keyFactory.generatePrivate(privateKeySpec);
            return rSAPrivateKey;
        }
        catch (Exception e) {
            throw new JwtCannotRetrieveKeyException("Error reading private key", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public RSAPublicKey readRsaPublicKeyFromPem(Reader reader) throws JwtCannotRetrieveKeyException {
        PEMParser pemParser = new PEMParser(reader);
        try {
            RSAPublicKey publicKey;
            Object object = pemParser.readObject();
            SubjectPublicKeyInfo pub = SubjectPublicKeyInfo.getInstance((Object)object);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            RSAPublicKey rSAPublicKey = publicKey = (RSAPublicKey)converter.getPublicKey(pub);
            return rSAPublicKey;
        }
        catch (Exception e) {
            throw new JwtCannotRetrieveKeyException("Error reading public key", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

