/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core;

import com.atlassian.jwt.Jwt;
import com.atlassian.jwt.JwtParser;
import com.atlassian.jwt.core.SimpleJwt;
import com.atlassian.jwt.exception.JwtParseException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import net.minidev.json.JSONObject;

public class SimpleJwtParser
implements JwtParser {
    public Jwt parse(String jwt) throws JwtParseException {
        JWSObject jwsObject = this.parseJWSObject(jwt);
        try {
            JWTClaimsSet claims = JWTClaimsSet.parse((JSONObject)jwsObject.getPayload().toJSONObject());
            return new SimpleJwt(claims.getIssuer(), claims.getSubject(), jwsObject.getPayload().toString());
        }
        catch (ParseException e) {
            throw new JwtParseException((Exception)e);
        }
    }

    private JWSObject parseJWSObject(String jwt) throws JwtParseException {
        JWSObject jwsObject;
        try {
            jwsObject = JWSObject.parse((String)jwt);
        }
        catch (ParseException e) {
            throw new JwtParseException((Exception)e);
        }
        return jwsObject;
    }
}

