/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.keys;

import com.atlassian.jwt.core.keys.KeyUtils;
import com.atlassian.jwt.core.keys.PrivateKeyRetriever;
import com.atlassian.jwt.exception.JwtCannotRetrieveKeyException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.interfaces.RSAPrivateKey;
import org.apache.commons.io.IOUtils;

public class PrivateKeyRetrieverImpl
implements PrivateKeyRetriever {
    private final PrivateKeyRetriever.keyLocationType type;
    private final String location;
    private final KeyUtils keyUtils;

    public PrivateKeyRetrieverImpl(PrivateKeyRetriever.keyLocationType type, String keyLocation) {
        this.type = type;
        this.location = keyLocation;
        this.keyUtils = new KeyUtils();
    }

    public PrivateKeyRetrieverImpl(PrivateKeyRetriever.keyLocationType type, String keyLocation, KeyUtils keyUtils) {
        this.type = type;
        this.location = keyLocation;
        this.keyUtils = keyUtils;
    }

    @Override
    public RSAPrivateKey getPrivateKey() throws JwtCannotRetrieveKeyException {
        if (this.type == PrivateKeyRetriever.keyLocationType.CLASSPATH_RESOURCE) {
            return this.getPrivateKeyFromClasspathResource();
        }
        if (this.type == PrivateKeyRetriever.keyLocationType.FILE) {
            return this.getPrivateKeyFromFile();
        }
        throw new JwtCannotRetrieveKeyException("Unsupported key location type " + (Object)((Object)this.type));
    }

    private RSAPrivateKey getPrivateKeyFromClasspathResource() throws JwtCannotRetrieveKeyException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.location);
        if (in == null) {
            throw new JwtCannotRetrieveKeyException("Could not load classpath resource " + this.location);
        }
        return this.keyUtils.readRsaPrivateKeyFromPem(new InputStreamReader(in));
    }

    private RSAPrivateKey getPrivateKeyFromFile() throws JwtCannotRetrieveKeyException {
        FileReader reader = null;
        try {
            System.out.println(new File(".").getCanonicalPath());
            reader = new FileReader(this.location);
        }
        catch (IOException e) {
            try {
                throw new JwtCannotRetrieveKeyException("Private key file not found: " + this.location, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return this.keyUtils.readRsaPrivateKeyFromPem(reader);
    }
}

