/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.writer;

import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.SigningInfo;
import com.atlassian.jwt.core.writer.NimbusJwtWriter;
import com.atlassian.jwt.writer.JwtWriter;
import com.atlassian.jwt.writer.JwtWriterFactory;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import java.security.interfaces.RSAPrivateKey;
import javax.annotation.Nonnull;

public class NimbusJwtWriterFactory
implements JwtWriterFactory {
    private NimbusJwtWriterFactoryHelper factoryHelper;

    public NimbusJwtWriterFactory() {
        this(new NimbusJwtWriterFactoryHelper());
    }

    public NimbusJwtWriterFactory(NimbusJwtWriterFactoryHelper factoryHelper) {
        this.factoryHelper = factoryHelper;
    }

    @Nonnull
    public JwtWriter macSigningWriter(@Nonnull SigningAlgorithm algorithm, @Nonnull String sharedSecret) {
        return new NimbusJwtWriter(algorithm, (JWSSigner)new MACSigner(sharedSecret));
    }

    public JwtWriter signingWriter(@Nonnull SigningInfo signingInfo) {
        if (signingInfo.getSharedSecret().isPresent()) {
            return this.factoryHelper.makeMacJwtWriter(signingInfo.getSigningAlgorithm(), new MACSigner((String)signingInfo.getSharedSecret().get()));
        }
        return this.factoryHelper.makeRsJwtWriter(signingInfo.getSigningAlgorithm(), new RSASSASigner((RSAPrivateKey)signingInfo.getPrivateKey().get()));
    }

    static class NimbusJwtWriterFactoryHelper {
        NimbusJwtWriterFactoryHelper() {
        }

        NimbusJwtWriter makeMacJwtWriter(SigningAlgorithm algorithm, MACSigner macSigner) {
            return new NimbusJwtWriter(algorithm, (JWSSigner)macSigner);
        }

        NimbusJwtWriter makeRsJwtWriter(SigningAlgorithm algorithm, RSASSASigner rsaSigner) {
            return new NimbusJwtWriter(algorithm, (JWSSigner)rsaSigner);
        }
    }
}

