/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core;

import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.SigningInfo;
import com.google.common.base.Optional;
import java.security.interfaces.RSAPrivateKey;
import javax.annotation.Nonnull;

public class SimpleSigningInfo
implements SigningInfo {
    private final SigningAlgorithm signingAlgorithm;
    private final Optional<RSAPrivateKey> privateKey;
    private final Optional<String> sharedSecret;

    public SimpleSigningInfo(SigningAlgorithm signingAlgorithm, @Nonnull RSAPrivateKey privateKey) {
        if (signingAlgorithm.requiresSharedSecret()) {
            throw new IllegalArgumentException("Algorithm requires a private key rather than a shared secret: " + signingAlgorithm);
        }
        this.signingAlgorithm = signingAlgorithm;
        this.privateKey = Optional.of((Object)privateKey);
        this.sharedSecret = Optional.absent();
    }

    public SimpleSigningInfo(SigningAlgorithm signingAlgorithm, @Nonnull String sharedSecret) {
        if (signingAlgorithm.requiresKeyPair()) {
            throw new IllegalArgumentException("Algorithm requires a shared secret rather than a private key: " + signingAlgorithm);
        }
        this.signingAlgorithm = signingAlgorithm;
        this.sharedSecret = Optional.of((Object)sharedSecret);
        this.privateKey = Optional.absent();
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public Optional<RSAPrivateKey> getPrivateKey() {
        return this.privateKey;
    }

    public Optional<String> getSharedSecret() {
        return this.sharedSecret;
    }
}

