/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.core.reader;

import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.SimpleJwt;
import com.atlassian.jwt.core.reader.JwtIssuerSharedSecretService;
import com.atlassian.jwt.core.reader.JwtIssuerValidator;
import com.atlassian.jwt.core.reader.NimbusMacJwtReader;
import com.atlassian.jwt.exception.JwsUnsupportedAlgorithmException;
import com.atlassian.jwt.exception.JwtIssuerLacksSharedSecretException;
import com.atlassian.jwt.exception.JwtParseException;
import com.atlassian.jwt.exception.JwtUnknownIssuerException;
import com.atlassian.jwt.reader.JwtReader;
import com.atlassian.jwt.reader.JwtReaderFactory;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;

public class NimbusJwtReaderFactory
implements JwtReaderFactory {
    private final JwtIssuerValidator jwtIssuerValidator;
    private final JwtIssuerSharedSecretService jwtIssuerSharedSecretService;

    public NimbusJwtReaderFactory(JwtIssuerValidator jwtIssuerValidator, JwtIssuerSharedSecretService jwtIssuerSharedSecretService) {
        this.jwtIssuerValidator = jwtIssuerValidator;
        this.jwtIssuerSharedSecretService = jwtIssuerSharedSecretService;
    }

    @Nonnull
    public JwtReader getReader(@Nonnull String jwt) throws JwtParseException, JwsUnsupportedAlgorithmException, JwtUnknownIssuerException, JwtIssuerLacksSharedSecretException {
        SimpleUnverifiedJwt unverifiedJwt = new NimbusUnverifiedJwtReader().parse(jwt);
        SigningAlgorithm algorithm = this.validateAlgorithm(unverifiedJwt);
        String issuer = this.validateIssuer(unverifiedJwt);
        if (algorithm.requiresSharedSecret()) {
            return this.macVerifyingReader(this.jwtIssuerSharedSecretService.getSharedSecret(issuer));
        }
        throw new JwsUnsupportedAlgorithmException(String.format("Currently we support only symmetric signing algorithms such as %s, and not %s. Try a symmetric algorithm.", SigningAlgorithm.HS256, algorithm.name()));
    }

    private JwtReader macVerifyingReader(String sharedSecret) {
        return new NimbusMacJwtReader(sharedSecret);
    }

    private String validateIssuer(SimpleUnverifiedJwt unverifiedJwt) throws JwtUnknownIssuerException {
        String issuer = unverifiedJwt.getIssuer();
        if (!this.jwtIssuerValidator.isValid(issuer)) {
            throw new JwtUnknownIssuerException(issuer);
        }
        return issuer;
    }

    private SigningAlgorithm validateAlgorithm(SimpleUnverifiedJwt unverifiedJwt) throws JwsUnsupportedAlgorithmException {
        return SigningAlgorithm.forName((String)unverifiedJwt.getAlgorithm());
    }

    private static class NimbusUnverifiedJwtReader {
        private NimbusUnverifiedJwtReader() {
        }

        public SimpleUnverifiedJwt parse(String jwt) throws JwtParseException {
            JWSObject jwsObject = this.parseJWSObject(jwt);
            try {
                JWTClaimsSet claims = JWTClaimsSet.parse((JSONObject)jwsObject.getPayload().toJSONObject());
                return new SimpleUnverifiedJwt(jwsObject.getHeader().getAlgorithm().getName(), claims.getIssuer(), claims.getSubject(), jwsObject.getPayload().toString());
            }
            catch (ParseException e) {
                throw new JwtParseException((Exception)e);
            }
        }

        private JWSObject parseJWSObject(String jwt) throws JwtParseException {
            JWSObject jwsObject;
            try {
                jwsObject = JWSObject.parse((String)jwt);
            }
            catch (ParseException e) {
                throw new JwtParseException((Exception)e);
            }
            return jwsObject;
        }
    }

    private static class SimpleUnverifiedJwt
    extends SimpleJwt {
        private final String algorithm;

        public SimpleUnverifiedJwt(String algorithm, String iss, String sub, String payload) {
            super(iss, sub, payload);
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

