/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.event;

import com.atlassian.johnson.config.JohnsonConfig;

public final class EventLevel {
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    public static final String FATAL = "fatal";
    private String level;
    private String description;

    public EventLevel(String level, String description) {
        this.level = level;
        this.description = description;
    }

    public static EventLevel get(String level) {
        return JohnsonConfig.getInstance().getEventLevel(level);
    }

    public String getLevel() {
        return this.level;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "(EventLevel: " + this.level + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventLevel)) {
            return false;
        }
        EventLevel eventLevel = (EventLevel)o;
        if (this.description != null ? !this.description.equals(eventLevel.description) : eventLevel.description != null) {
            return false;
        }
        return this.level.equals(eventLevel.level);
    }

    public int hashCode() {
        int result = this.level.hashCode();
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

