/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.event;

import com.atlassian.johnson.config.JohnsonConfig;

public final class EventType {
    private String type;
    private String description;

    public EventType(String type, String description) {
        this.type = type;
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public static EventType get(String type) {
        return JohnsonConfig.getInstance().getEventType(type);
    }

    public String toString() {
        return "(EventType: " + this.type + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventType)) {
            return false;
        }
        EventType eventType = (EventType)o;
        if (this.description != null ? !this.description.equals(eventType.description) : eventType.description != null) {
            return false;
        }
        return this.type.equals(eventType.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

