/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.filters;

import com.atlassian.core.filters.AbstractFilter;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.RequestEventCheck;
import com.atlassian.johnson.setup.SetupConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractJohnsonFilter
extends AbstractFilter {
    protected static final String TEXT_XML_UTF8_CONTENT_TYPE = "text/xml;charset=utf-8";
    protected FilterConfig filterConfig = null;
    protected JohnsonConfig config;

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.config = JohnsonConfig.getInstance();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String alreadyFilteredKey = ((Object)((Object)this)).getClass().getName() + "_already_filtered";
        if (servletRequest.getAttribute(alreadyFilteredKey) != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        servletRequest.setAttribute(alreadyFilteredKey, (Object)Boolean.TRUE);
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        String servletPath = AbstractJohnsonFilter.getServletPath(req);
        JohnsonEventContainer appEventContainer = this.getContainerAndRunEventChecks(req);
        SetupConfig setup = this.config.getSetupConfig();
        if (appEventContainer.hasEvents() && !this.ignoreURI(servletPath)) {
            this.handleError(appEventContainer, req, resp);
        } else if (!(this.ignoreURI(servletPath) || setup.isSetup() || setup.isSetupPage(servletPath))) {
            this.handleNotSetup(req, resp);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected abstract void handleError(JohnsonEventContainer var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    protected abstract void handleNotSetup(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected boolean ignoreURI(String uri) {
        return uri.equalsIgnoreCase(this.config.getErrorPath()) || this.config.isIgnoredPath(uri);
    }

    protected static String getServletPath(HttpServletRequest request) {
        int endIndex;
        String servletPath = request.getServletPath();
        if (null != servletPath && !"".equals(servletPath)) {
            return servletPath;
        }
        String requestUri = request.getRequestURI();
        int startIndex = request.getContextPath().equals("") ? 0 : request.getContextPath().length();
        int n = endIndex = request.getPathInfo() == null ? requestUri.length() : requestUri.lastIndexOf(request.getPathInfo());
        if (startIndex > endIndex) {
            endIndex = startIndex;
        }
        return requestUri.substring(startIndex, endIndex);
    }

    protected JohnsonEventContainer getContainerAndRunEventChecks(HttpServletRequest req) {
        JohnsonEventContainer appEventContainer = JohnsonEventContainer.get(this.filterConfig.getServletContext());
        Iterator iterator = this.config.getRequestEventChecks().iterator();
        while (iterator.hasNext()) {
            RequestEventCheck requestEventCheck = (RequestEventCheck)iterator.next();
            requestEventCheck.check(appEventContainer, req);
        }
        return appEventContainer;
    }

    protected String getStringForEvents(Collection events) {
        StringBuffer message = new StringBuffer();
        int i = 1;
        Iterator iterator = events.iterator();
        while (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            message.append(event.getDesc());
            if (i < events.size()) {
                message.append("\n");
            }
            ++i;
        }
        return message.toString();
    }
}

