/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson;

import com.atlassian.johnson.event.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;

public class JohnsonEventContainer {
    public static String SERVLET_CONTEXT_KEY = JohnsonEventContainer.class.getName();
    private static JohnsonEventContainer instance;
    private Map events = new WeakHashMap();

    public static synchronized JohnsonEventContainer getInstance() {
        if (instance == null) {
            instance = new JohnsonEventContainer();
        }
        return instance;
    }

    public static synchronized JohnsonEventContainer get(ServletContext context) {
        if (context.getAttribute(SERVLET_CONTEXT_KEY) == null) {
            context.setAttribute(SERVLET_CONTEXT_KEY, (Object)JohnsonEventContainer.getInstance());
        }
        return (JohnsonEventContainer)context.getAttribute(SERVLET_CONTEXT_KEY);
    }

    public boolean hasEvents() {
        return !this.events.isEmpty();
    }

    public void addEvent(Event event) {
        this.events.put(event, event);
    }

    public void removeEvent(Event event) {
        this.events.remove(event);
    }

    public Collection getEvents() {
        return Collections.unmodifiableCollection(new ArrayList(this.events.values()));
    }
}

