/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.web.context.support;

import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.spring.web.context.JohnsonContextLoaderListener;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.HttpRequestHandlerServlet;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class JohnsonHttpRequestHandlerServlet
extends HttpRequestHandlerServlet {
    private static final Logger LOG = LoggerFactory.getLogger(JohnsonHttpRequestHandlerServlet.class);
    private static final Field TARGET = ReflectionUtils.findField(HttpRequestHandlerServlet.class, (String)"target");
    private final Object lock = new Object();
    private String contextAttribute;
    private volatile boolean uninitialised = true;

    public String getContextAttribute() {
        return this.contextAttribute;
    }

    public void init() throws ServletException {
        this.applyParameters();
        this.maybeInit();
    }

    public void setContextAttribute(String contextAttribute) {
        this.contextAttribute = contextAttribute;
    }

    protected void applyParameters() {
        ServletConfig config = this.getServletConfig();
        if (config != null) {
            this.setContextAttribute(config.getInitParameter("contextAttribute"));
        }
    }

    protected void sendRedirect(@Nonnull HttpServletResponse response) throws IOException {
        ServletContext servletContext = this.getServletContext();
        JohnsonConfig config = Johnson.getConfig((ServletContext)servletContext);
        LOG.warn("HttpRequestHandlerServlet [{}] cannot be initialised to service an incoming request; redirecting to {}", (Object)this.getServletName(), (Object)config.getErrorPath());
        response.sendRedirect(servletContext.getContextPath() + config.getErrorPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ServletException, IOException {
        if (this.uninitialised) {
            Object object = this.lock;
            synchronized (object) {
                if (this.uninitialised && !this.maybeInit()) {
                    this.sendRedirect(response);
                    return;
                }
            }
        }
        super.service(request, response);
    }

    private void enhancedInit() throws ServletException {
        WebApplicationContext wac = this.findWebApplicationContext();
        ReflectionUtils.setField((Field)TARGET, (Object)((Object)this), (Object)wac.getBean(this.getServletName(), HttpRequestHandler.class));
    }

    private WebApplicationContext findWebApplicationContext() {
        String attribute = this.getContextAttribute();
        if (attribute == null) {
            return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        }
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext(), (String)attribute);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext was found on the '" + attribute + "' attribute on the ServletContext");
        }
        return wac;
    }

    private boolean maybeInit() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        Object attribute = servletContext.getAttribute(JohnsonContextLoaderListener.ATTR_BYPASSED);
        if (Boolean.TRUE == attribute) {
            LOG.error("Bypassing HttpRequestHandlerServlet [{}] initialisation; Spring initialisation was bypassed", (Object)this.getServletName());
            return false;
        }
        if (attribute instanceof Event) {
            Event event = (Event)attribute;
            LOG.error("Bypassing HttpRequestHandlerServlet [{}] initialisation; Spring initialisation failed: {}", (Object)this.getServletName(), (Object)event.getDesc());
            return false;
        }
        try {
            this.enhancedInit();
            this.uninitialised = false;
        }
        catch (Exception e) {
            LOG.error("HttpRequestHandlerServlet [" + this.getServletName() + "] could not be started", (Throwable)e);
            return false;
        }
        return true;
    }

    static {
        ReflectionUtils.makeAccessible((Field)TARGET);
    }
}

